/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.connect.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.connect.model.MetricDataV2;

@SdkInternalApi
public class MetricDataV2Marshaller {
    private static final MarshallingInfo<StructuredPojo> METRIC_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Metric").build();
    private static final MarshallingInfo<Double> VALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Value").build();
    private static final MetricDataV2Marshaller instance = new MetricDataV2Marshaller();

    public static MetricDataV2Marshaller getInstance() {
        return instance;
    }

    public void marshall(MetricDataV2 metricDataV2, ProtocolMarshaller protocolMarshaller) {
        if (metricDataV2 == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)metricDataV2.getMetric(), METRIC_BINDING);
            protocolMarshaller.marshall((Object)metricDataV2.getValue(), VALUE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

