/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.connect.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.connect.model.QueueType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListQueuesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String instanceId;
    private List<String> queueTypes;
    private String nextToken;
    private Integer maxResults;

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public ListQueuesRequest withInstanceId(String instanceId) {
        this.setInstanceId(instanceId);
        return this;
    }

    public List<String> getQueueTypes() {
        return this.queueTypes;
    }

    public void setQueueTypes(Collection<String> queueTypes) {
        if (queueTypes == null) {
            this.queueTypes = null;
            return;
        }
        this.queueTypes = new ArrayList<String>(queueTypes);
    }

    public ListQueuesRequest withQueueTypes(String ... queueTypes) {
        if (this.queueTypes == null) {
            this.setQueueTypes(new ArrayList<String>(queueTypes.length));
        }
        for (String ele : queueTypes) {
            this.queueTypes.add(ele);
        }
        return this;
    }

    public ListQueuesRequest withQueueTypes(Collection<String> queueTypes) {
        this.setQueueTypes(queueTypes);
        return this;
    }

    public ListQueuesRequest withQueueTypes(QueueType ... queueTypes) {
        ArrayList<String> queueTypesCopy = new ArrayList<String>(queueTypes.length);
        for (QueueType value : queueTypes) {
            queueTypesCopy.add(value.toString());
        }
        if (this.getQueueTypes() == null) {
            this.setQueueTypes(queueTypesCopy);
        } else {
            this.getQueueTypes().addAll(queueTypesCopy);
        }
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListQueuesRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public ListQueuesRequest withMaxResults(Integer maxResults) {
        this.setMaxResults(maxResults);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getInstanceId() != null) {
            sb.append("InstanceId: ").append(this.getInstanceId()).append(",");
        }
        if (this.getQueueTypes() != null) {
            sb.append("QueueTypes: ").append(this.getQueueTypes()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: ").append(this.getMaxResults());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListQueuesRequest)) {
            return false;
        }
        ListQueuesRequest other = (ListQueuesRequest)obj;
        if (other.getInstanceId() == null ^ this.getInstanceId() == null) {
            return false;
        }
        if (other.getInstanceId() != null && !other.getInstanceId().equals(this.getInstanceId())) {
            return false;
        }
        if (other.getQueueTypes() == null ^ this.getQueueTypes() == null) {
            return false;
        }
        if (other.getQueueTypes() != null && !other.getQueueTypes().equals(this.getQueueTypes())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        return other.getMaxResults() == null || other.getMaxResults().equals(this.getMaxResults());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getInstanceId() == null ? 0 : this.getInstanceId().hashCode());
        hashCode = 31 * hashCode + (this.getQueueTypes() == null ? 0 : this.getQueueTypes().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        return hashCode;
    }

    public ListQueuesRequest clone() {
        return (ListQueuesRequest)super.clone();
    }
}

