/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.connect.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.connect.model.Campaign;
import com.amazonaws.services.connect.model.Endpoint;
import com.amazonaws.services.connect.model.transform.ContactDataRequestMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class ContactDataRequest
implements Serializable,
Cloneable,
StructuredPojo {
    private Endpoint systemEndpoint;
    private Endpoint customerEndpoint;
    private String requestIdentifier;
    private String queueId;
    private Map<String, String> attributes;
    private Campaign campaign;

    public void setSystemEndpoint(Endpoint systemEndpoint) {
        this.systemEndpoint = systemEndpoint;
    }

    public Endpoint getSystemEndpoint() {
        return this.systemEndpoint;
    }

    public ContactDataRequest withSystemEndpoint(Endpoint systemEndpoint) {
        this.setSystemEndpoint(systemEndpoint);
        return this;
    }

    public void setCustomerEndpoint(Endpoint customerEndpoint) {
        this.customerEndpoint = customerEndpoint;
    }

    public Endpoint getCustomerEndpoint() {
        return this.customerEndpoint;
    }

    public ContactDataRequest withCustomerEndpoint(Endpoint customerEndpoint) {
        this.setCustomerEndpoint(customerEndpoint);
        return this;
    }

    public void setRequestIdentifier(String requestIdentifier) {
        this.requestIdentifier = requestIdentifier;
    }

    public String getRequestIdentifier() {
        return this.requestIdentifier;
    }

    public ContactDataRequest withRequestIdentifier(String requestIdentifier) {
        this.setRequestIdentifier(requestIdentifier);
        return this;
    }

    public void setQueueId(String queueId) {
        this.queueId = queueId;
    }

    public String getQueueId() {
        return this.queueId;
    }

    public ContactDataRequest withQueueId(String queueId) {
        this.setQueueId(queueId);
        return this;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public ContactDataRequest withAttributes(Map<String, String> attributes) {
        this.setAttributes(attributes);
        return this;
    }

    public ContactDataRequest addAttributesEntry(String key, String value) {
        if (null == this.attributes) {
            this.attributes = new HashMap<String, String>();
        }
        if (this.attributes.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.attributes.put(key, value);
        return this;
    }

    public ContactDataRequest clearAttributesEntries() {
        this.attributes = null;
        return this;
    }

    public void setCampaign(Campaign campaign) {
        this.campaign = campaign;
    }

    public Campaign getCampaign() {
        return this.campaign;
    }

    public ContactDataRequest withCampaign(Campaign campaign) {
        this.setCampaign(campaign);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSystemEndpoint() != null) {
            sb.append("SystemEndpoint: ").append(this.getSystemEndpoint()).append(",");
        }
        if (this.getCustomerEndpoint() != null) {
            sb.append("CustomerEndpoint: ").append(this.getCustomerEndpoint()).append(",");
        }
        if (this.getRequestIdentifier() != null) {
            sb.append("RequestIdentifier: ").append(this.getRequestIdentifier()).append(",");
        }
        if (this.getQueueId() != null) {
            sb.append("QueueId: ").append(this.getQueueId()).append(",");
        }
        if (this.getAttributes() != null) {
            sb.append("Attributes: ").append(this.getAttributes()).append(",");
        }
        if (this.getCampaign() != null) {
            sb.append("Campaign: ").append(this.getCampaign());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContactDataRequest)) {
            return false;
        }
        ContactDataRequest other = (ContactDataRequest)obj;
        if (other.getSystemEndpoint() == null ^ this.getSystemEndpoint() == null) {
            return false;
        }
        if (other.getSystemEndpoint() != null && !other.getSystemEndpoint().equals(this.getSystemEndpoint())) {
            return false;
        }
        if (other.getCustomerEndpoint() == null ^ this.getCustomerEndpoint() == null) {
            return false;
        }
        if (other.getCustomerEndpoint() != null && !other.getCustomerEndpoint().equals(this.getCustomerEndpoint())) {
            return false;
        }
        if (other.getRequestIdentifier() == null ^ this.getRequestIdentifier() == null) {
            return false;
        }
        if (other.getRequestIdentifier() != null && !other.getRequestIdentifier().equals(this.getRequestIdentifier())) {
            return false;
        }
        if (other.getQueueId() == null ^ this.getQueueId() == null) {
            return false;
        }
        if (other.getQueueId() != null && !other.getQueueId().equals(this.getQueueId())) {
            return false;
        }
        if (other.getAttributes() == null ^ this.getAttributes() == null) {
            return false;
        }
        if (other.getAttributes() != null && !other.getAttributes().equals(this.getAttributes())) {
            return false;
        }
        if (other.getCampaign() == null ^ this.getCampaign() == null) {
            return false;
        }
        return other.getCampaign() == null || other.getCampaign().equals(this.getCampaign());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSystemEndpoint() == null ? 0 : this.getSystemEndpoint().hashCode());
        hashCode = 31 * hashCode + (this.getCustomerEndpoint() == null ? 0 : this.getCustomerEndpoint().hashCode());
        hashCode = 31 * hashCode + (this.getRequestIdentifier() == null ? 0 : this.getRequestIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getQueueId() == null ? 0 : this.getQueueId().hashCode());
        hashCode = 31 * hashCode + (this.getAttributes() == null ? 0 : this.getAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getCampaign() == null ? 0 : this.getCampaign().hashCode());
        return hashCode;
    }

    public ContactDataRequest clone() {
        try {
            return (ContactDataRequest)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ContactDataRequestMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

