/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.connect.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.connect.model.Transcript;
import java.util.List;

@SdkInternalApi
public class TranscriptMarshaller {
    private static final MarshallingInfo<List> CRITERIA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Criteria").build();
    private static final MarshallingInfo<String> MATCHTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MatchType").build();
    private static final TranscriptMarshaller instance = new TranscriptMarshaller();

    public static TranscriptMarshaller getInstance() {
        return instance;
    }

    public void marshall(Transcript transcript, ProtocolMarshaller protocolMarshaller) {
        if (transcript == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(transcript.getCriteria(), CRITERIA_BINDING);
            protocolMarshaller.marshall((Object)transcript.getMatchType(), MATCHTYPE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

