/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.connect.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.connect.model.AgentHierarchyGroups;
import com.amazonaws.services.connect.model.Channel;
import com.amazonaws.services.connect.model.ContactAnalysis;
import com.amazonaws.services.connect.model.ContactInitiationMethod;
import com.amazonaws.services.connect.model.SearchableContactAttributes;
import com.amazonaws.services.connect.model.transform.SearchCriteriaMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SearchCriteria
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> agentIds;
    private AgentHierarchyGroups agentHierarchyGroups;
    private List<String> channels;
    private ContactAnalysis contactAnalysis;
    private List<String> initiationMethods;
    private List<String> queueIds;
    private SearchableContactAttributes searchableContactAttributes;

    public List<String> getAgentIds() {
        return this.agentIds;
    }

    public void setAgentIds(Collection<String> agentIds) {
        if (agentIds == null) {
            this.agentIds = null;
            return;
        }
        this.agentIds = new ArrayList<String>(agentIds);
    }

    public SearchCriteria withAgentIds(String ... agentIds) {
        if (this.agentIds == null) {
            this.setAgentIds(new ArrayList<String>(agentIds.length));
        }
        for (String ele : agentIds) {
            this.agentIds.add(ele);
        }
        return this;
    }

    public SearchCriteria withAgentIds(Collection<String> agentIds) {
        this.setAgentIds(agentIds);
        return this;
    }

    public void setAgentHierarchyGroups(AgentHierarchyGroups agentHierarchyGroups) {
        this.agentHierarchyGroups = agentHierarchyGroups;
    }

    public AgentHierarchyGroups getAgentHierarchyGroups() {
        return this.agentHierarchyGroups;
    }

    public SearchCriteria withAgentHierarchyGroups(AgentHierarchyGroups agentHierarchyGroups) {
        this.setAgentHierarchyGroups(agentHierarchyGroups);
        return this;
    }

    public List<String> getChannels() {
        return this.channels;
    }

    public void setChannels(Collection<String> channels) {
        if (channels == null) {
            this.channels = null;
            return;
        }
        this.channels = new ArrayList<String>(channels);
    }

    public SearchCriteria withChannels(String ... channels) {
        if (this.channels == null) {
            this.setChannels(new ArrayList<String>(channels.length));
        }
        for (String ele : channels) {
            this.channels.add(ele);
        }
        return this;
    }

    public SearchCriteria withChannels(Collection<String> channels) {
        this.setChannels(channels);
        return this;
    }

    public SearchCriteria withChannels(Channel ... channels) {
        ArrayList<String> channelsCopy = new ArrayList<String>(channels.length);
        for (Channel value : channels) {
            channelsCopy.add(value.toString());
        }
        if (this.getChannels() == null) {
            this.setChannels(channelsCopy);
        } else {
            this.getChannels().addAll(channelsCopy);
        }
        return this;
    }

    public void setContactAnalysis(ContactAnalysis contactAnalysis) {
        this.contactAnalysis = contactAnalysis;
    }

    public ContactAnalysis getContactAnalysis() {
        return this.contactAnalysis;
    }

    public SearchCriteria withContactAnalysis(ContactAnalysis contactAnalysis) {
        this.setContactAnalysis(contactAnalysis);
        return this;
    }

    public List<String> getInitiationMethods() {
        return this.initiationMethods;
    }

    public void setInitiationMethods(Collection<String> initiationMethods) {
        if (initiationMethods == null) {
            this.initiationMethods = null;
            return;
        }
        this.initiationMethods = new ArrayList<String>(initiationMethods);
    }

    public SearchCriteria withInitiationMethods(String ... initiationMethods) {
        if (this.initiationMethods == null) {
            this.setInitiationMethods(new ArrayList<String>(initiationMethods.length));
        }
        for (String ele : initiationMethods) {
            this.initiationMethods.add(ele);
        }
        return this;
    }

    public SearchCriteria withInitiationMethods(Collection<String> initiationMethods) {
        this.setInitiationMethods(initiationMethods);
        return this;
    }

    public SearchCriteria withInitiationMethods(ContactInitiationMethod ... initiationMethods) {
        ArrayList<String> initiationMethodsCopy = new ArrayList<String>(initiationMethods.length);
        for (ContactInitiationMethod value : initiationMethods) {
            initiationMethodsCopy.add(value.toString());
        }
        if (this.getInitiationMethods() == null) {
            this.setInitiationMethods(initiationMethodsCopy);
        } else {
            this.getInitiationMethods().addAll(initiationMethodsCopy);
        }
        return this;
    }

    public List<String> getQueueIds() {
        return this.queueIds;
    }

    public void setQueueIds(Collection<String> queueIds) {
        if (queueIds == null) {
            this.queueIds = null;
            return;
        }
        this.queueIds = new ArrayList<String>(queueIds);
    }

    public SearchCriteria withQueueIds(String ... queueIds) {
        if (this.queueIds == null) {
            this.setQueueIds(new ArrayList<String>(queueIds.length));
        }
        for (String ele : queueIds) {
            this.queueIds.add(ele);
        }
        return this;
    }

    public SearchCriteria withQueueIds(Collection<String> queueIds) {
        this.setQueueIds(queueIds);
        return this;
    }

    public void setSearchableContactAttributes(SearchableContactAttributes searchableContactAttributes) {
        this.searchableContactAttributes = searchableContactAttributes;
    }

    public SearchableContactAttributes getSearchableContactAttributes() {
        return this.searchableContactAttributes;
    }

    public SearchCriteria withSearchableContactAttributes(SearchableContactAttributes searchableContactAttributes) {
        this.setSearchableContactAttributes(searchableContactAttributes);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAgentIds() != null) {
            sb.append("AgentIds: ").append(this.getAgentIds()).append(",");
        }
        if (this.getAgentHierarchyGroups() != null) {
            sb.append("AgentHierarchyGroups: ").append(this.getAgentHierarchyGroups()).append(",");
        }
        if (this.getChannels() != null) {
            sb.append("Channels: ").append(this.getChannels()).append(",");
        }
        if (this.getContactAnalysis() != null) {
            sb.append("ContactAnalysis: ").append(this.getContactAnalysis()).append(",");
        }
        if (this.getInitiationMethods() != null) {
            sb.append("InitiationMethods: ").append(this.getInitiationMethods()).append(",");
        }
        if (this.getQueueIds() != null) {
            sb.append("QueueIds: ").append(this.getQueueIds()).append(",");
        }
        if (this.getSearchableContactAttributes() != null) {
            sb.append("SearchableContactAttributes: ").append(this.getSearchableContactAttributes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchCriteria)) {
            return false;
        }
        SearchCriteria other = (SearchCriteria)obj;
        if (other.getAgentIds() == null ^ this.getAgentIds() == null) {
            return false;
        }
        if (other.getAgentIds() != null && !other.getAgentIds().equals(this.getAgentIds())) {
            return false;
        }
        if (other.getAgentHierarchyGroups() == null ^ this.getAgentHierarchyGroups() == null) {
            return false;
        }
        if (other.getAgentHierarchyGroups() != null && !other.getAgentHierarchyGroups().equals(this.getAgentHierarchyGroups())) {
            return false;
        }
        if (other.getChannels() == null ^ this.getChannels() == null) {
            return false;
        }
        if (other.getChannels() != null && !other.getChannels().equals(this.getChannels())) {
            return false;
        }
        if (other.getContactAnalysis() == null ^ this.getContactAnalysis() == null) {
            return false;
        }
        if (other.getContactAnalysis() != null && !other.getContactAnalysis().equals(this.getContactAnalysis())) {
            return false;
        }
        if (other.getInitiationMethods() == null ^ this.getInitiationMethods() == null) {
            return false;
        }
        if (other.getInitiationMethods() != null && !other.getInitiationMethods().equals(this.getInitiationMethods())) {
            return false;
        }
        if (other.getQueueIds() == null ^ this.getQueueIds() == null) {
            return false;
        }
        if (other.getQueueIds() != null && !other.getQueueIds().equals(this.getQueueIds())) {
            return false;
        }
        if (other.getSearchableContactAttributes() == null ^ this.getSearchableContactAttributes() == null) {
            return false;
        }
        return other.getSearchableContactAttributes() == null || other.getSearchableContactAttributes().equals(this.getSearchableContactAttributes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAgentIds() == null ? 0 : this.getAgentIds().hashCode());
        hashCode = 31 * hashCode + (this.getAgentHierarchyGroups() == null ? 0 : this.getAgentHierarchyGroups().hashCode());
        hashCode = 31 * hashCode + (this.getChannels() == null ? 0 : this.getChannels().hashCode());
        hashCode = 31 * hashCode + (this.getContactAnalysis() == null ? 0 : this.getContactAnalysis().hashCode());
        hashCode = 31 * hashCode + (this.getInitiationMethods() == null ? 0 : this.getInitiationMethods().hashCode());
        hashCode = 31 * hashCode + (this.getQueueIds() == null ? 0 : this.getQueueIds().hashCode());
        hashCode = 31 * hashCode + (this.getSearchableContactAttributes() == null ? 0 : this.getSearchableContactAttributes().hashCode());
        return hashCode;
    }

    public SearchCriteria clone() {
        try {
            return (SearchCriteria)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SearchCriteriaMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

