/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.connect.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.connect.model.OutboundCallerConfig;
import com.amazonaws.services.connect.model.QueueStatus;
import com.amazonaws.services.connect.model.transform.QueueMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class Queue
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private String queueArn;
    private String queueId;
    private String description;
    private OutboundCallerConfig outboundCallerConfig;
    private String hoursOfOperationId;
    private Integer maxContacts;
    private String status;
    private Map<String, String> tags;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Queue withName(String name) {
        this.setName(name);
        return this;
    }

    public void setQueueArn(String queueArn) {
        this.queueArn = queueArn;
    }

    public String getQueueArn() {
        return this.queueArn;
    }

    public Queue withQueueArn(String queueArn) {
        this.setQueueArn(queueArn);
        return this;
    }

    public void setQueueId(String queueId) {
        this.queueId = queueId;
    }

    public String getQueueId() {
        return this.queueId;
    }

    public Queue withQueueId(String queueId) {
        this.setQueueId(queueId);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public Queue withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setOutboundCallerConfig(OutboundCallerConfig outboundCallerConfig) {
        this.outboundCallerConfig = outboundCallerConfig;
    }

    public OutboundCallerConfig getOutboundCallerConfig() {
        return this.outboundCallerConfig;
    }

    public Queue withOutboundCallerConfig(OutboundCallerConfig outboundCallerConfig) {
        this.setOutboundCallerConfig(outboundCallerConfig);
        return this;
    }

    public void setHoursOfOperationId(String hoursOfOperationId) {
        this.hoursOfOperationId = hoursOfOperationId;
    }

    public String getHoursOfOperationId() {
        return this.hoursOfOperationId;
    }

    public Queue withHoursOfOperationId(String hoursOfOperationId) {
        this.setHoursOfOperationId(hoursOfOperationId);
        return this;
    }

    public void setMaxContacts(Integer maxContacts) {
        this.maxContacts = maxContacts;
    }

    public Integer getMaxContacts() {
        return this.maxContacts;
    }

    public Queue withMaxContacts(Integer maxContacts) {
        this.setMaxContacts(maxContacts);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public Queue withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public Queue withStatus(QueueStatus status) {
        this.status = status.toString();
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public Queue withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public Queue addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public Queue clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getQueueArn() != null) {
            sb.append("QueueArn: ").append(this.getQueueArn()).append(",");
        }
        if (this.getQueueId() != null) {
            sb.append("QueueId: ").append(this.getQueueId()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getOutboundCallerConfig() != null) {
            sb.append("OutboundCallerConfig: ").append(this.getOutboundCallerConfig()).append(",");
        }
        if (this.getHoursOfOperationId() != null) {
            sb.append("HoursOfOperationId: ").append(this.getHoursOfOperationId()).append(",");
        }
        if (this.getMaxContacts() != null) {
            sb.append("MaxContacts: ").append(this.getMaxContacts()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Queue)) {
            return false;
        }
        Queue other = (Queue)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getQueueArn() == null ^ this.getQueueArn() == null) {
            return false;
        }
        if (other.getQueueArn() != null && !other.getQueueArn().equals(this.getQueueArn())) {
            return false;
        }
        if (other.getQueueId() == null ^ this.getQueueId() == null) {
            return false;
        }
        if (other.getQueueId() != null && !other.getQueueId().equals(this.getQueueId())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getOutboundCallerConfig() == null ^ this.getOutboundCallerConfig() == null) {
            return false;
        }
        if (other.getOutboundCallerConfig() != null && !other.getOutboundCallerConfig().equals(this.getOutboundCallerConfig())) {
            return false;
        }
        if (other.getHoursOfOperationId() == null ^ this.getHoursOfOperationId() == null) {
            return false;
        }
        if (other.getHoursOfOperationId() != null && !other.getHoursOfOperationId().equals(this.getHoursOfOperationId())) {
            return false;
        }
        if (other.getMaxContacts() == null ^ this.getMaxContacts() == null) {
            return false;
        }
        if (other.getMaxContacts() != null && !other.getMaxContacts().equals(this.getMaxContacts())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getQueueArn() == null ? 0 : this.getQueueArn().hashCode());
        hashCode = 31 * hashCode + (this.getQueueId() == null ? 0 : this.getQueueId().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getOutboundCallerConfig() == null ? 0 : this.getOutboundCallerConfig().hashCode());
        hashCode = 31 * hashCode + (this.getHoursOfOperationId() == null ? 0 : this.getHoursOfOperationId().hashCode());
        hashCode = 31 * hashCode + (this.getMaxContacts() == null ? 0 : this.getMaxContacts().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public Queue clone() {
        try {
            return (Queue)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        QueueMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

