/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.config.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.config.model.AggregateResourceIdentifier;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ListAggregateDiscoveredResourcesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private SdkInternalList<AggregateResourceIdentifier> resourceIdentifiers;
    private String nextToken;

    public List<AggregateResourceIdentifier> getResourceIdentifiers() {
        if (this.resourceIdentifiers == null) {
            this.resourceIdentifiers = new SdkInternalList();
        }
        return this.resourceIdentifiers;
    }

    public void setResourceIdentifiers(Collection<AggregateResourceIdentifier> resourceIdentifiers) {
        if (resourceIdentifiers == null) {
            this.resourceIdentifiers = null;
            return;
        }
        this.resourceIdentifiers = new SdkInternalList(resourceIdentifiers);
    }

    public ListAggregateDiscoveredResourcesResult withResourceIdentifiers(AggregateResourceIdentifier ... resourceIdentifiers) {
        if (this.resourceIdentifiers == null) {
            this.setResourceIdentifiers((Collection<AggregateResourceIdentifier>)new SdkInternalList(resourceIdentifiers.length));
        }
        for (AggregateResourceIdentifier ele : resourceIdentifiers) {
            this.resourceIdentifiers.add((Object)ele);
        }
        return this;
    }

    public ListAggregateDiscoveredResourcesResult withResourceIdentifiers(Collection<AggregateResourceIdentifier> resourceIdentifiers) {
        this.setResourceIdentifiers(resourceIdentifiers);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListAggregateDiscoveredResourcesResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResourceIdentifiers() != null) {
            sb.append("ResourceIdentifiers: ").append(this.getResourceIdentifiers()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAggregateDiscoveredResourcesResult)) {
            return false;
        }
        ListAggregateDiscoveredResourcesResult other = (ListAggregateDiscoveredResourcesResult)obj;
        if (other.getResourceIdentifiers() == null ^ this.getResourceIdentifiers() == null) {
            return false;
        }
        if (other.getResourceIdentifiers() != null && !other.getResourceIdentifiers().equals(this.getResourceIdentifiers())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getResourceIdentifiers() == null ? 0 : this.getResourceIdentifiers().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListAggregateDiscoveredResourcesResult clone() {
        try {
            return (ListAggregateDiscoveredResourcesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

