/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.config.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.config.model.DescribeComplianceByConfigRuleRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class DescribeComplianceByConfigRuleRequestMarshaller
implements Marshaller<Request<DescribeComplianceByConfigRuleRequest>, DescribeComplianceByConfigRuleRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DescribeComplianceByConfigRuleRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<DescribeComplianceByConfigRuleRequest> marshall(DescribeComplianceByConfigRuleRequest describeComplianceByConfigRuleRequest) {
        if (describeComplianceByConfigRuleRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeComplianceByConfigRuleRequest, "AmazonConfig");
        request.addHeader("X-Amz-Target", "StarlingDoveService.DescribeComplianceByConfigRule");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList complianceTypesList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            SdkInternalList configRuleNamesList = (SdkInternalList)describeComplianceByConfigRuleRequest.getConfigRuleNames();
            if (!configRuleNamesList.isEmpty() || !configRuleNamesList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("ConfigRuleNames");
                jsonGenerator.writeStartArray();
                for (String configRuleNamesListValue : configRuleNamesList) {
                    if (configRuleNamesListValue == null) continue;
                    jsonGenerator.writeValue(configRuleNamesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (!(complianceTypesList = (SdkInternalList)describeComplianceByConfigRuleRequest.getComplianceTypes()).isEmpty() || !complianceTypesList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("ComplianceTypes");
                jsonGenerator.writeStartArray();
                for (String complianceTypesListValue : complianceTypesList) {
                    if (complianceTypesListValue == null) continue;
                    jsonGenerator.writeValue(complianceTypesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (describeComplianceByConfigRuleRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("NextToken").writeValue(describeComplianceByConfigRuleRequest.getNextToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

