/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.config.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.config.model.DescribeConfigRulesRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class DescribeConfigRulesRequestMarshaller
implements Marshaller<Request<DescribeConfigRulesRequest>, DescribeConfigRulesRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DescribeConfigRulesRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<DescribeConfigRulesRequest> marshall(DescribeConfigRulesRequest describeConfigRulesRequest) {
        if (describeConfigRulesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeConfigRulesRequest, "AmazonConfig");
        request.addHeader("X-Amz-Target", "StarlingDoveService.DescribeConfigRules");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            SdkInternalList configRuleNamesList = (SdkInternalList)describeConfigRulesRequest.getConfigRuleNames();
            if (!configRuleNamesList.isEmpty() || !configRuleNamesList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("ConfigRuleNames");
                jsonGenerator.writeStartArray();
                for (String configRuleNamesListValue : configRuleNamesList) {
                    if (configRuleNamesListValue == null) continue;
                    jsonGenerator.writeValue(configRuleNamesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (describeConfigRulesRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("NextToken").writeValue(describeConfigRulesRequest.getNextToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

