/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.config.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.config.model.DeliveryChannel;
import com.amazonaws.services.config.model.transform.ConfigSnapshotDeliveryPropertiesJsonMarshaller;

public class DeliveryChannelJsonMarshaller {
    private static DeliveryChannelJsonMarshaller instance;

    public void marshall(DeliveryChannel deliveryChannel, StructuredJsonGenerator jsonGenerator) {
        if (deliveryChannel == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (deliveryChannel.getName() != null) {
                jsonGenerator.writeFieldName("name").writeValue(deliveryChannel.getName());
            }
            if (deliveryChannel.getS3BucketName() != null) {
                jsonGenerator.writeFieldName("s3BucketName").writeValue(deliveryChannel.getS3BucketName());
            }
            if (deliveryChannel.getS3KeyPrefix() != null) {
                jsonGenerator.writeFieldName("s3KeyPrefix").writeValue(deliveryChannel.getS3KeyPrefix());
            }
            if (deliveryChannel.getSnsTopicARN() != null) {
                jsonGenerator.writeFieldName("snsTopicARN").writeValue(deliveryChannel.getSnsTopicARN());
            }
            if (deliveryChannel.getConfigSnapshotDeliveryProperties() != null) {
                jsonGenerator.writeFieldName("configSnapshotDeliveryProperties");
                ConfigSnapshotDeliveryPropertiesJsonMarshaller.getInstance().marshall(deliveryChannel.getConfigSnapshotDeliveryProperties(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static DeliveryChannelJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new DeliveryChannelJsonMarshaller();
        }
        return instance;
    }
}

