/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.config.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.config.model.ConfigurationItem;
import com.amazonaws.services.config.model.Relationship;
import com.amazonaws.services.config.model.transform.RelationshipJsonMarshaller;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.util.Map;

public class ConfigurationItemJsonMarshaller {
    private static ConfigurationItemJsonMarshaller instance;

    public void marshall(ConfigurationItem configurationItem, StructuredJsonGenerator jsonGenerator) {
        if (configurationItem == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList relationshipsList;
            SdkInternalList relatedEventsList;
            Map<String, String> tagsMap;
            jsonGenerator.writeStartObject();
            if (configurationItem.getVersion() != null) {
                jsonGenerator.writeFieldName("version").writeValue(configurationItem.getVersion());
            }
            if (configurationItem.getAccountId() != null) {
                jsonGenerator.writeFieldName("accountId").writeValue(configurationItem.getAccountId());
            }
            if (configurationItem.getConfigurationItemCaptureTime() != null) {
                jsonGenerator.writeFieldName("configurationItemCaptureTime").writeValue(configurationItem.getConfigurationItemCaptureTime());
            }
            if (configurationItem.getConfigurationItemStatus() != null) {
                jsonGenerator.writeFieldName("configurationItemStatus").writeValue(configurationItem.getConfigurationItemStatus());
            }
            if (configurationItem.getConfigurationStateId() != null) {
                jsonGenerator.writeFieldName("configurationStateId").writeValue(configurationItem.getConfigurationStateId());
            }
            if (configurationItem.getConfigurationItemMD5Hash() != null) {
                jsonGenerator.writeFieldName("configurationItemMD5Hash").writeValue(configurationItem.getConfigurationItemMD5Hash());
            }
            if (configurationItem.getArn() != null) {
                jsonGenerator.writeFieldName("arn").writeValue(configurationItem.getArn());
            }
            if (configurationItem.getResourceType() != null) {
                jsonGenerator.writeFieldName("resourceType").writeValue(configurationItem.getResourceType());
            }
            if (configurationItem.getResourceId() != null) {
                jsonGenerator.writeFieldName("resourceId").writeValue(configurationItem.getResourceId());
            }
            if (configurationItem.getResourceName() != null) {
                jsonGenerator.writeFieldName("resourceName").writeValue(configurationItem.getResourceName());
            }
            if (configurationItem.getAwsRegion() != null) {
                jsonGenerator.writeFieldName("awsRegion").writeValue(configurationItem.getAwsRegion());
            }
            if (configurationItem.getAvailabilityZone() != null) {
                jsonGenerator.writeFieldName("availabilityZone").writeValue(configurationItem.getAvailabilityZone());
            }
            if (configurationItem.getResourceCreationTime() != null) {
                jsonGenerator.writeFieldName("resourceCreationTime").writeValue(configurationItem.getResourceCreationTime());
            }
            if ((tagsMap = configurationItem.getTags()) != null) {
                jsonGenerator.writeFieldName("tags");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, String> tagsMapValue : tagsMap.entrySet()) {
                    if (tagsMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName((String)tagsMapValue.getKey());
                    jsonGenerator.writeValue((String)tagsMapValue.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            if (!(relatedEventsList = (SdkInternalList)configurationItem.getRelatedEvents()).isEmpty() || !relatedEventsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("relatedEvents");
                jsonGenerator.writeStartArray();
                for (String relatedEventsListValue : relatedEventsList) {
                    if (relatedEventsListValue == null) continue;
                    jsonGenerator.writeValue(relatedEventsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (!(relationshipsList = (SdkInternalList)configurationItem.getRelationships()).isEmpty() || !relationshipsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("relationships");
                jsonGenerator.writeStartArray();
                for (Relationship relationshipsListValue : relationshipsList) {
                    if (relationshipsListValue == null) continue;
                    RelationshipJsonMarshaller.getInstance().marshall(relationshipsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (configurationItem.getConfiguration() != null) {
                jsonGenerator.writeFieldName("configuration").writeValue(configurationItem.getConfiguration());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ConfigurationItemJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ConfigurationItemJsonMarshaller();
        }
        return instance;
    }
}

