/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.config.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.config.model.ConfigurationItemStatus;
import com.amazonaws.services.config.model.Relationship;
import com.amazonaws.services.config.model.ResourceType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConfigurationItem
implements Serializable,
Cloneable {
    private String version;
    private String accountId;
    private Date configurationItemCaptureTime;
    private String configurationItemStatus;
    private String configurationStateId;
    private String configurationItemMD5Hash;
    private String arn;
    private String resourceType;
    private String resourceId;
    private String resourceName;
    private String awsRegion;
    private String availabilityZone;
    private Date resourceCreationTime;
    private Map<String, String> tags;
    private ListWithAutoConstructFlag<String> relatedEvents;
    private ListWithAutoConstructFlag<Relationship> relationships;
    private String configuration;

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public ConfigurationItem withVersion(String version) {
        this.version = version;
        return this;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public ConfigurationItem withAccountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    public Date getConfigurationItemCaptureTime() {
        return this.configurationItemCaptureTime;
    }

    public void setConfigurationItemCaptureTime(Date configurationItemCaptureTime) {
        this.configurationItemCaptureTime = configurationItemCaptureTime;
    }

    public ConfigurationItem withConfigurationItemCaptureTime(Date configurationItemCaptureTime) {
        this.configurationItemCaptureTime = configurationItemCaptureTime;
        return this;
    }

    public String getConfigurationItemStatus() {
        return this.configurationItemStatus;
    }

    public void setConfigurationItemStatus(String configurationItemStatus) {
        this.configurationItemStatus = configurationItemStatus;
    }

    public ConfigurationItem withConfigurationItemStatus(String configurationItemStatus) {
        this.configurationItemStatus = configurationItemStatus;
        return this;
    }

    public void setConfigurationItemStatus(ConfigurationItemStatus configurationItemStatus) {
        this.configurationItemStatus = configurationItemStatus.toString();
    }

    public ConfigurationItem withConfigurationItemStatus(ConfigurationItemStatus configurationItemStatus) {
        this.configurationItemStatus = configurationItemStatus.toString();
        return this;
    }

    public String getConfigurationStateId() {
        return this.configurationStateId;
    }

    public void setConfigurationStateId(String configurationStateId) {
        this.configurationStateId = configurationStateId;
    }

    public ConfigurationItem withConfigurationStateId(String configurationStateId) {
        this.configurationStateId = configurationStateId;
        return this;
    }

    public String getConfigurationItemMD5Hash() {
        return this.configurationItemMD5Hash;
    }

    public void setConfigurationItemMD5Hash(String configurationItemMD5Hash) {
        this.configurationItemMD5Hash = configurationItemMD5Hash;
    }

    public ConfigurationItem withConfigurationItemMD5Hash(String configurationItemMD5Hash) {
        this.configurationItemMD5Hash = configurationItemMD5Hash;
        return this;
    }

    public String getArn() {
        return this.arn;
    }

    public void setArn(String arn) {
        this.arn = arn;
    }

    public ConfigurationItem withArn(String arn) {
        this.arn = arn;
        return this;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public ConfigurationItem withResourceType(String resourceType) {
        this.resourceType = resourceType;
        return this;
    }

    public void setResourceType(ResourceType resourceType) {
        this.resourceType = resourceType.toString();
    }

    public ConfigurationItem withResourceType(ResourceType resourceType) {
        this.resourceType = resourceType.toString();
        return this;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public ConfigurationItem withResourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public ConfigurationItem withResourceName(String resourceName) {
        this.resourceName = resourceName;
        return this;
    }

    public String getAwsRegion() {
        return this.awsRegion;
    }

    public void setAwsRegion(String awsRegion) {
        this.awsRegion = awsRegion;
    }

    public ConfigurationItem withAwsRegion(String awsRegion) {
        this.awsRegion = awsRegion;
        return this;
    }

    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    public void setAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
    }

    public ConfigurationItem withAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
        return this;
    }

    public Date getResourceCreationTime() {
        return this.resourceCreationTime;
    }

    public void setResourceCreationTime(Date resourceCreationTime) {
        this.resourceCreationTime = resourceCreationTime;
    }

    public ConfigurationItem withResourceCreationTime(Date resourceCreationTime) {
        this.resourceCreationTime = resourceCreationTime;
        return this;
    }

    public Map<String, String> getTags() {
        if (this.tags == null) {
            this.tags = new HashMap<String, String>();
        }
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public ConfigurationItem withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public ConfigurationItem addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public ConfigurationItem clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public List<String> getRelatedEvents() {
        if (this.relatedEvents == null) {
            this.relatedEvents = new ListWithAutoConstructFlag();
            this.relatedEvents.setAutoConstruct(true);
        }
        return this.relatedEvents;
    }

    public void setRelatedEvents(Collection<String> relatedEvents) {
        if (relatedEvents == null) {
            this.relatedEvents = null;
            return;
        }
        ListWithAutoConstructFlag relatedEventsCopy = new ListWithAutoConstructFlag(relatedEvents.size());
        relatedEventsCopy.addAll(relatedEvents);
        this.relatedEvents = relatedEventsCopy;
    }

    public ConfigurationItem withRelatedEvents(String ... relatedEvents) {
        if (this.getRelatedEvents() == null) {
            this.setRelatedEvents(new ArrayList<String>(relatedEvents.length));
        }
        for (String value : relatedEvents) {
            this.getRelatedEvents().add(value);
        }
        return this;
    }

    public ConfigurationItem withRelatedEvents(Collection<String> relatedEvents) {
        if (relatedEvents == null) {
            this.relatedEvents = null;
        } else {
            ListWithAutoConstructFlag relatedEventsCopy = new ListWithAutoConstructFlag(relatedEvents.size());
            relatedEventsCopy.addAll(relatedEvents);
            this.relatedEvents = relatedEventsCopy;
        }
        return this;
    }

    public List<Relationship> getRelationships() {
        if (this.relationships == null) {
            this.relationships = new ListWithAutoConstructFlag();
            this.relationships.setAutoConstruct(true);
        }
        return this.relationships;
    }

    public void setRelationships(Collection<Relationship> relationships) {
        if (relationships == null) {
            this.relationships = null;
            return;
        }
        ListWithAutoConstructFlag relationshipsCopy = new ListWithAutoConstructFlag(relationships.size());
        relationshipsCopy.addAll(relationships);
        this.relationships = relationshipsCopy;
    }

    public ConfigurationItem withRelationships(Relationship ... relationships) {
        if (this.getRelationships() == null) {
            this.setRelationships(new ArrayList<Relationship>(relationships.length));
        }
        for (Relationship value : relationships) {
            this.getRelationships().add(value);
        }
        return this;
    }

    public ConfigurationItem withRelationships(Collection<Relationship> relationships) {
        if (relationships == null) {
            this.relationships = null;
        } else {
            ListWithAutoConstructFlag relationshipsCopy = new ListWithAutoConstructFlag(relationships.size());
            relationshipsCopy.addAll(relationships);
            this.relationships = relationshipsCopy;
        }
        return this;
    }

    public String getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(String configuration) {
        this.configuration = configuration;
    }

    public ConfigurationItem withConfiguration(String configuration) {
        this.configuration = configuration;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getVersion() != null) {
            sb.append("Version: " + this.getVersion() + ",");
        }
        if (this.getAccountId() != null) {
            sb.append("AccountId: " + this.getAccountId() + ",");
        }
        if (this.getConfigurationItemCaptureTime() != null) {
            sb.append("ConfigurationItemCaptureTime: " + this.getConfigurationItemCaptureTime() + ",");
        }
        if (this.getConfigurationItemStatus() != null) {
            sb.append("ConfigurationItemStatus: " + this.getConfigurationItemStatus() + ",");
        }
        if (this.getConfigurationStateId() != null) {
            sb.append("ConfigurationStateId: " + this.getConfigurationStateId() + ",");
        }
        if (this.getConfigurationItemMD5Hash() != null) {
            sb.append("ConfigurationItemMD5Hash: " + this.getConfigurationItemMD5Hash() + ",");
        }
        if (this.getArn() != null) {
            sb.append("Arn: " + this.getArn() + ",");
        }
        if (this.getResourceType() != null) {
            sb.append("ResourceType: " + this.getResourceType() + ",");
        }
        if (this.getResourceId() != null) {
            sb.append("ResourceId: " + this.getResourceId() + ",");
        }
        if (this.getResourceName() != null) {
            sb.append("ResourceName: " + this.getResourceName() + ",");
        }
        if (this.getAwsRegion() != null) {
            sb.append("AwsRegion: " + this.getAwsRegion() + ",");
        }
        if (this.getAvailabilityZone() != null) {
            sb.append("AvailabilityZone: " + this.getAvailabilityZone() + ",");
        }
        if (this.getResourceCreationTime() != null) {
            sb.append("ResourceCreationTime: " + this.getResourceCreationTime() + ",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: " + this.getTags() + ",");
        }
        if (this.getRelatedEvents() != null) {
            sb.append("RelatedEvents: " + this.getRelatedEvents() + ",");
        }
        if (this.getRelationships() != null) {
            sb.append("Relationships: " + this.getRelationships() + ",");
        }
        if (this.getConfiguration() != null) {
            sb.append("Configuration: " + this.getConfiguration());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getVersion() == null ? 0 : this.getVersion().hashCode());
        hashCode = 31 * hashCode + (this.getAccountId() == null ? 0 : this.getAccountId().hashCode());
        hashCode = 31 * hashCode + (this.getConfigurationItemCaptureTime() == null ? 0 : this.getConfigurationItemCaptureTime().hashCode());
        hashCode = 31 * hashCode + (this.getConfigurationItemStatus() == null ? 0 : this.getConfigurationItemStatus().hashCode());
        hashCode = 31 * hashCode + (this.getConfigurationStateId() == null ? 0 : this.getConfigurationStateId().hashCode());
        hashCode = 31 * hashCode + (this.getConfigurationItemMD5Hash() == null ? 0 : this.getConfigurationItemMD5Hash().hashCode());
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getResourceType() == null ? 0 : this.getResourceType().hashCode());
        hashCode = 31 * hashCode + (this.getResourceId() == null ? 0 : this.getResourceId().hashCode());
        hashCode = 31 * hashCode + (this.getResourceName() == null ? 0 : this.getResourceName().hashCode());
        hashCode = 31 * hashCode + (this.getAwsRegion() == null ? 0 : this.getAwsRegion().hashCode());
        hashCode = 31 * hashCode + (this.getAvailabilityZone() == null ? 0 : this.getAvailabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.getResourceCreationTime() == null ? 0 : this.getResourceCreationTime().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getRelatedEvents() == null ? 0 : this.getRelatedEvents().hashCode());
        hashCode = 31 * hashCode + (this.getRelationships() == null ? 0 : this.getRelationships().hashCode());
        hashCode = 31 * hashCode + (this.getConfiguration() == null ? 0 : this.getConfiguration().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurationItem)) {
            return false;
        }
        ConfigurationItem other = (ConfigurationItem)obj;
        if (other.getVersion() == null ^ this.getVersion() == null) {
            return false;
        }
        if (other.getVersion() != null && !other.getVersion().equals(this.getVersion())) {
            return false;
        }
        if (other.getAccountId() == null ^ this.getAccountId() == null) {
            return false;
        }
        if (other.getAccountId() != null && !other.getAccountId().equals(this.getAccountId())) {
            return false;
        }
        if (other.getConfigurationItemCaptureTime() == null ^ this.getConfigurationItemCaptureTime() == null) {
            return false;
        }
        if (other.getConfigurationItemCaptureTime() != null && !other.getConfigurationItemCaptureTime().equals(this.getConfigurationItemCaptureTime())) {
            return false;
        }
        if (other.getConfigurationItemStatus() == null ^ this.getConfigurationItemStatus() == null) {
            return false;
        }
        if (other.getConfigurationItemStatus() != null && !other.getConfigurationItemStatus().equals(this.getConfigurationItemStatus())) {
            return false;
        }
        if (other.getConfigurationStateId() == null ^ this.getConfigurationStateId() == null) {
            return false;
        }
        if (other.getConfigurationStateId() != null && !other.getConfigurationStateId().equals(this.getConfigurationStateId())) {
            return false;
        }
        if (other.getConfigurationItemMD5Hash() == null ^ this.getConfigurationItemMD5Hash() == null) {
            return false;
        }
        if (other.getConfigurationItemMD5Hash() != null && !other.getConfigurationItemMD5Hash().equals(this.getConfigurationItemMD5Hash())) {
            return false;
        }
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getResourceType() == null ^ this.getResourceType() == null) {
            return false;
        }
        if (other.getResourceType() != null && !other.getResourceType().equals(this.getResourceType())) {
            return false;
        }
        if (other.getResourceId() == null ^ this.getResourceId() == null) {
            return false;
        }
        if (other.getResourceId() != null && !other.getResourceId().equals(this.getResourceId())) {
            return false;
        }
        if (other.getResourceName() == null ^ this.getResourceName() == null) {
            return false;
        }
        if (other.getResourceName() != null && !other.getResourceName().equals(this.getResourceName())) {
            return false;
        }
        if (other.getAwsRegion() == null ^ this.getAwsRegion() == null) {
            return false;
        }
        if (other.getAwsRegion() != null && !other.getAwsRegion().equals(this.getAwsRegion())) {
            return false;
        }
        if (other.getAvailabilityZone() == null ^ this.getAvailabilityZone() == null) {
            return false;
        }
        if (other.getAvailabilityZone() != null && !other.getAvailabilityZone().equals(this.getAvailabilityZone())) {
            return false;
        }
        if (other.getResourceCreationTime() == null ^ this.getResourceCreationTime() == null) {
            return false;
        }
        if (other.getResourceCreationTime() != null && !other.getResourceCreationTime().equals(this.getResourceCreationTime())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getRelatedEvents() == null ^ this.getRelatedEvents() == null) {
            return false;
        }
        if (other.getRelatedEvents() != null && !other.getRelatedEvents().equals(this.getRelatedEvents())) {
            return false;
        }
        if (other.getRelationships() == null ^ this.getRelationships() == null) {
            return false;
        }
        if (other.getRelationships() != null && !other.getRelationships().equals(this.getRelationships())) {
            return false;
        }
        if (other.getConfiguration() == null ^ this.getConfiguration() == null) {
            return false;
        }
        return other.getConfiguration() == null || other.getConfiguration().equals(this.getConfiguration());
    }

    public ConfigurationItem clone() {
        try {
            return (ConfigurationItem)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

