/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.config.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.config.model.ResourceIdentifier;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListDiscoveredResourcesResult
implements Serializable,
Cloneable {
    private ListWithAutoConstructFlag<ResourceIdentifier> resourceIdentifiers;
    private String nextToken;

    public List<ResourceIdentifier> getResourceIdentifiers() {
        if (this.resourceIdentifiers == null) {
            this.resourceIdentifiers = new ListWithAutoConstructFlag();
            this.resourceIdentifiers.setAutoConstruct(true);
        }
        return this.resourceIdentifiers;
    }

    public void setResourceIdentifiers(Collection<ResourceIdentifier> resourceIdentifiers) {
        if (resourceIdentifiers == null) {
            this.resourceIdentifiers = null;
            return;
        }
        ListWithAutoConstructFlag resourceIdentifiersCopy = new ListWithAutoConstructFlag(resourceIdentifiers.size());
        resourceIdentifiersCopy.addAll(resourceIdentifiers);
        this.resourceIdentifiers = resourceIdentifiersCopy;
    }

    public ListDiscoveredResourcesResult withResourceIdentifiers(ResourceIdentifier ... resourceIdentifiers) {
        if (this.getResourceIdentifiers() == null) {
            this.setResourceIdentifiers(new ArrayList<ResourceIdentifier>(resourceIdentifiers.length));
        }
        for (ResourceIdentifier value : resourceIdentifiers) {
            this.getResourceIdentifiers().add(value);
        }
        return this;
    }

    public ListDiscoveredResourcesResult withResourceIdentifiers(Collection<ResourceIdentifier> resourceIdentifiers) {
        if (resourceIdentifiers == null) {
            this.resourceIdentifiers = null;
        } else {
            ListWithAutoConstructFlag resourceIdentifiersCopy = new ListWithAutoConstructFlag(resourceIdentifiers.size());
            resourceIdentifiersCopy.addAll(resourceIdentifiers);
            this.resourceIdentifiers = resourceIdentifiersCopy;
        }
        return this;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public ListDiscoveredResourcesResult withNextToken(String nextToken) {
        this.nextToken = nextToken;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResourceIdentifiers() != null) {
            sb.append("ResourceIdentifiers: " + this.getResourceIdentifiers() + ",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: " + this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getResourceIdentifiers() == null ? 0 : this.getResourceIdentifiers().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDiscoveredResourcesResult)) {
            return false;
        }
        ListDiscoveredResourcesResult other = (ListDiscoveredResourcesResult)obj;
        if (other.getResourceIdentifiers() == null ^ this.getResourceIdentifiers() == null) {
            return false;
        }
        if (other.getResourceIdentifiers() != null && !other.getResourceIdentifiers().equals(this.getResourceIdentifiers())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public ListDiscoveredResourcesResult clone() {
        try {
            return (ListDiscoveredResourcesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

