/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.comprehend.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.comprehend.model.ToxicLabels;
import java.util.List;

@SdkInternalApi
public class ToxicLabelsMarshaller {
    private static final MarshallingInfo<List> LABELS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Labels").build();
    private static final MarshallingInfo<Float> TOXICITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Toxicity").build();
    private static final ToxicLabelsMarshaller instance = new ToxicLabelsMarshaller();

    public static ToxicLabelsMarshaller getInstance() {
        return instance;
    }

    public void marshall(ToxicLabels toxicLabels, ProtocolMarshaller protocolMarshaller) {
        if (toxicLabels == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(toxicLabels.getLabels(), LABELS_BINDING);
            protocolMarshaller.marshall((Object)toxicLabels.getToxicity(), TOXICITY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

