/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.comprehend.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.comprehend.model.DocumentClassifierMode;
import com.amazonaws.services.comprehend.model.transform.DocumentClassificationConfigMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DocumentClassificationConfig
implements Serializable,
Cloneable,
StructuredPojo {
    private String mode;
    private List<String> labels;

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String getMode() {
        return this.mode;
    }

    public DocumentClassificationConfig withMode(String mode) {
        this.setMode(mode);
        return this;
    }

    public DocumentClassificationConfig withMode(DocumentClassifierMode mode) {
        this.mode = mode.toString();
        return this;
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public void setLabels(Collection<String> labels) {
        if (labels == null) {
            this.labels = null;
            return;
        }
        this.labels = new ArrayList<String>(labels);
    }

    public DocumentClassificationConfig withLabels(String ... labels) {
        if (this.labels == null) {
            this.setLabels(new ArrayList<String>(labels.length));
        }
        for (String ele : labels) {
            this.labels.add(ele);
        }
        return this;
    }

    public DocumentClassificationConfig withLabels(Collection<String> labels) {
        this.setLabels(labels);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMode() != null) {
            sb.append("Mode: ").append(this.getMode()).append(",");
        }
        if (this.getLabels() != null) {
            sb.append("Labels: ").append(this.getLabels());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentClassificationConfig)) {
            return false;
        }
        DocumentClassificationConfig other = (DocumentClassificationConfig)obj;
        if (other.getMode() == null ^ this.getMode() == null) {
            return false;
        }
        if (other.getMode() != null && !other.getMode().equals(this.getMode())) {
            return false;
        }
        if (other.getLabels() == null ^ this.getLabels() == null) {
            return false;
        }
        return other.getLabels() == null || other.getLabels().equals(this.getLabels());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMode() == null ? 0 : this.getMode().hashCode());
        hashCode = 31 * hashCode + (this.getLabels() == null ? 0 : this.getLabels().hashCode());
        return hashCode;
    }

    public DocumentClassificationConfig clone() {
        try {
            return (DocumentClassificationConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DocumentClassificationConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

