/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitosync.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cognitosync.model.RecordPatch;
import com.amazonaws.services.cognitosync.model.UpdateRecordsRequest;
import com.amazonaws.services.cognitosync.model.transform.RecordPatchJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class UpdateRecordsRequestMarshaller
implements Marshaller<Request<UpdateRecordsRequest>, UpdateRecordsRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "application/x-amz-json-1.1";

    public Request<UpdateRecordsRequest> marshall(UpdateRecordsRequest updateRecordsRequest) {
        if (updateRecordsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateRecordsRequest, "AmazonCognitoSync");
        request.setHttpMethod(HttpMethodName.POST);
        if (updateRecordsRequest.getClientContext() != null) {
            request.addHeader("x-amz-Client-Context", StringUtils.fromString((String)updateRecordsRequest.getClientContext()));
        }
        String uriResourcePath = "/identitypools/{IdentityPoolId}/identities/{IdentityId}/datasets/{DatasetName}";
        uriResourcePath = uriResourcePath.replace("{IdentityPoolId}", updateRecordsRequest.getIdentityPoolId() != null ? StringUtils.fromString((String)updateRecordsRequest.getIdentityPoolId()) : "");
        uriResourcePath = uriResourcePath.replace("{IdentityId}", updateRecordsRequest.getIdentityId() != null ? StringUtils.fromString((String)updateRecordsRequest.getIdentityId()) : "");
        uriResourcePath = uriResourcePath.replace("{DatasetName}", updateRecordsRequest.getDatasetName() != null ? StringUtils.fromString((String)updateRecordsRequest.getDatasetName()) : "");
        request.setResourcePath(uriResourcePath);
        try {
            SdkInternalList recordPatchesList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (updateRecordsRequest.getDeviceId() != null) {
                jsonWriter.key("DeviceId").value((Object)updateRecordsRequest.getDeviceId());
            }
            if (!(recordPatchesList = (SdkInternalList)updateRecordsRequest.getRecordPatches()).isEmpty() || !recordPatchesList.isAutoConstruct()) {
                jsonWriter.key("RecordPatches");
                jsonWriter.array();
                for (RecordPatch recordPatchesListValue : recordPatchesList) {
                    if (recordPatchesListValue == null) continue;
                    RecordPatchJsonMarshaller.getInstance().marshall(recordPatchesListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (updateRecordsRequest.getSyncSessionToken() != null) {
                jsonWriter.key("SyncSessionToken").value((Object)updateRecordsRequest.getSyncSessionToken());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
            }
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

