/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitosync.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.cognitosync.model.Record;
import com.amazonaws.util.json.JSONWriter;

public class RecordJsonMarshaller {
    private static RecordJsonMarshaller instance;

    public void marshall(Record record, JSONWriter jsonWriter) {
        if (record == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (record.getKey() != null) {
                jsonWriter.key("Key").value((Object)record.getKey());
            }
            if (record.getValue() != null) {
                jsonWriter.key("Value").value((Object)record.getValue());
            }
            if (record.getSyncCount() != null) {
                jsonWriter.key("SyncCount").value((Object)record.getSyncCount());
            }
            if (record.getLastModifiedDate() != null) {
                jsonWriter.key("LastModifiedDate").value(record.getLastModifiedDate());
            }
            if (record.getLastModifiedBy() != null) {
                jsonWriter.key("LastModifiedBy").value((Object)record.getLastModifiedBy());
            }
            if (record.getDeviceLastModifiedDate() != null) {
                jsonWriter.key("DeviceLastModifiedDate").value(record.getDeviceLastModifiedDate());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static RecordJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new RecordJsonMarshaller();
        }
        return instance;
    }
}

