/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidp.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.cognitoidp.model.ResendConfirmationCodeRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class ResendConfirmationCodeRequestMarshaller
implements Marshaller<Request<ResendConfirmationCodeRequest>, ResendConfirmationCodeRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public ResendConfirmationCodeRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<ResendConfirmationCodeRequest> marshall(ResendConfirmationCodeRequest resendConfirmationCodeRequest) {
        if (resendConfirmationCodeRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)resendConfirmationCodeRequest, "AWSCognitoIdentityProvider");
        request.addHeader("X-Amz-Target", "AWSCognitoIdentityProviderService.ResendConfirmationCode");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (resendConfirmationCodeRequest.getClientId() != null) {
                jsonGenerator.writeFieldName("ClientId").writeValue(resendConfirmationCodeRequest.getClientId());
            }
            if (resendConfirmationCodeRequest.getSecretHash() != null) {
                jsonGenerator.writeFieldName("SecretHash").writeValue(resendConfirmationCodeRequest.getSecretHash());
            }
            if (resendConfirmationCodeRequest.getUsername() != null) {
                jsonGenerator.writeFieldName("Username").writeValue(resendConfirmationCodeRequest.getUsername());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

