/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidp.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.cognitoidp.model.ConfirmSignUpRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class ConfirmSignUpRequestMarshaller
implements Marshaller<Request<ConfirmSignUpRequest>, ConfirmSignUpRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public ConfirmSignUpRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<ConfirmSignUpRequest> marshall(ConfirmSignUpRequest confirmSignUpRequest) {
        if (confirmSignUpRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)confirmSignUpRequest, "AWSCognitoIdentityProvider");
        request.addHeader("X-Amz-Target", "AWSCognitoIdentityProviderService.ConfirmSignUp");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (confirmSignUpRequest.getClientId() != null) {
                jsonGenerator.writeFieldName("ClientId").writeValue(confirmSignUpRequest.getClientId());
            }
            if (confirmSignUpRequest.getSecretHash() != null) {
                jsonGenerator.writeFieldName("SecretHash").writeValue(confirmSignUpRequest.getSecretHash());
            }
            if (confirmSignUpRequest.getUsername() != null) {
                jsonGenerator.writeFieldName("Username").writeValue(confirmSignUpRequest.getUsername());
            }
            if (confirmSignUpRequest.getConfirmationCode() != null) {
                jsonGenerator.writeFieldName("ConfirmationCode").writeValue(confirmSignUpRequest.getConfirmationCode());
            }
            if (confirmSignUpRequest.getForceAliasCreation() != null) {
                jsonGenerator.writeFieldName("ForceAliasCreation").writeValue(confirmSignUpRequest.getForceAliasCreation().booleanValue());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

