/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidp.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.cognitoidp.model.InitiateAuthRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;

public class InitiateAuthRequestMarshaller
implements Marshaller<Request<InitiateAuthRequest>, InitiateAuthRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public InitiateAuthRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<InitiateAuthRequest> marshall(InitiateAuthRequest initiateAuthRequest) {
        if (initiateAuthRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)initiateAuthRequest, "AWSCognitoIdentityProvider");
        request.addHeader("X-Amz-Target", "AWSCognitoIdentityProviderService.InitiateAuth");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            Map<String, String> clientMetadataMap;
            Map<String, String> authParametersMap;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (initiateAuthRequest.getAuthFlow() != null) {
                jsonGenerator.writeFieldName("AuthFlow").writeValue(initiateAuthRequest.getAuthFlow());
            }
            if ((authParametersMap = initiateAuthRequest.getAuthParameters()) != null) {
                jsonGenerator.writeFieldName("AuthParameters");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, String> authParametersMapValue : authParametersMap.entrySet()) {
                    if (authParametersMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName((String)authParametersMapValue.getKey());
                    jsonGenerator.writeValue((String)authParametersMapValue.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            if ((clientMetadataMap = initiateAuthRequest.getClientMetadata()) != null) {
                jsonGenerator.writeFieldName("ClientMetadata");
                jsonGenerator.writeStartObject();
                for (Map.Entry entry : clientMetadataMap.entrySet()) {
                    if (entry.getValue() == null) continue;
                    jsonGenerator.writeFieldName((String)entry.getKey());
                    jsonGenerator.writeValue((String)entry.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            if (initiateAuthRequest.getClientId() != null) {
                jsonGenerator.writeFieldName("ClientId").writeValue(initiateAuthRequest.getClientId());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

