/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidp.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.cognitoidp.model.VerifyUserAttributeRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class VerifyUserAttributeRequestMarshaller
implements Marshaller<Request<VerifyUserAttributeRequest>, VerifyUserAttributeRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public VerifyUserAttributeRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<VerifyUserAttributeRequest> marshall(VerifyUserAttributeRequest verifyUserAttributeRequest) {
        if (verifyUserAttributeRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)verifyUserAttributeRequest, "AWSCognitoIdentityProvider");
        request.addHeader("X-Amz-Target", "AWSCognitoIdentityProviderService.VerifyUserAttribute");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (verifyUserAttributeRequest.getAccessToken() != null) {
                jsonGenerator.writeFieldName("AccessToken").writeValue(verifyUserAttributeRequest.getAccessToken());
            }
            if (verifyUserAttributeRequest.getAttributeName() != null) {
                jsonGenerator.writeFieldName("AttributeName").writeValue(verifyUserAttributeRequest.getAttributeName());
            }
            if (verifyUserAttributeRequest.getCode() != null) {
                jsonGenerator.writeFieldName("Code").writeValue(verifyUserAttributeRequest.getCode());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

