/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codestarconnections;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.codestarconnections.AWSCodeStarconnectionsAsync;
import com.amazonaws.services.codestarconnections.AWSCodeStarconnectionsAsyncClientBuilder;
import com.amazonaws.services.codestarconnections.AWSCodeStarconnectionsClient;
import com.amazonaws.services.codestarconnections.model.CreateConnectionRequest;
import com.amazonaws.services.codestarconnections.model.CreateConnectionResult;
import com.amazonaws.services.codestarconnections.model.DeleteConnectionRequest;
import com.amazonaws.services.codestarconnections.model.DeleteConnectionResult;
import com.amazonaws.services.codestarconnections.model.GetConnectionRequest;
import com.amazonaws.services.codestarconnections.model.GetConnectionResult;
import com.amazonaws.services.codestarconnections.model.ListConnectionsRequest;
import com.amazonaws.services.codestarconnections.model.ListConnectionsResult;
import com.amazonaws.services.codestarconnections.model.ListTagsForResourceRequest;
import com.amazonaws.services.codestarconnections.model.ListTagsForResourceResult;
import com.amazonaws.services.codestarconnections.model.TagResourceRequest;
import com.amazonaws.services.codestarconnections.model.TagResourceResult;
import com.amazonaws.services.codestarconnections.model.UntagResourceRequest;
import com.amazonaws.services.codestarconnections.model.UntagResourceResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSCodeStarconnectionsAsyncClient
extends AWSCodeStarconnectionsClient
implements AWSCodeStarconnectionsAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSCodeStarconnectionsAsyncClientBuilder asyncBuilder() {
        return AWSCodeStarconnectionsAsyncClientBuilder.standard();
    }

    AWSCodeStarconnectionsAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super((AwsSyncClientParams)asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateConnectionResult> createConnectionAsync(CreateConnectionRequest request) {
        return this.createConnectionAsync(request, null);
    }

    @Override
    public Future<CreateConnectionResult> createConnectionAsync(CreateConnectionRequest request, final AsyncHandler<CreateConnectionRequest, CreateConnectionResult> asyncHandler) {
        final CreateConnectionRequest finalRequest = (CreateConnectionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateConnectionResult>(){

            @Override
            public CreateConnectionResult call() throws Exception {
                CreateConnectionResult result = null;
                try {
                    result = AWSCodeStarconnectionsAsyncClient.this.executeCreateConnection(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteConnectionResult> deleteConnectionAsync(DeleteConnectionRequest request) {
        return this.deleteConnectionAsync(request, null);
    }

    @Override
    public Future<DeleteConnectionResult> deleteConnectionAsync(DeleteConnectionRequest request, final AsyncHandler<DeleteConnectionRequest, DeleteConnectionResult> asyncHandler) {
        final DeleteConnectionRequest finalRequest = (DeleteConnectionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteConnectionResult>(){

            @Override
            public DeleteConnectionResult call() throws Exception {
                DeleteConnectionResult result = null;
                try {
                    result = AWSCodeStarconnectionsAsyncClient.this.executeDeleteConnection(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetConnectionResult> getConnectionAsync(GetConnectionRequest request) {
        return this.getConnectionAsync(request, null);
    }

    @Override
    public Future<GetConnectionResult> getConnectionAsync(GetConnectionRequest request, final AsyncHandler<GetConnectionRequest, GetConnectionResult> asyncHandler) {
        final GetConnectionRequest finalRequest = (GetConnectionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetConnectionResult>(){

            @Override
            public GetConnectionResult call() throws Exception {
                GetConnectionResult result = null;
                try {
                    result = AWSCodeStarconnectionsAsyncClient.this.executeGetConnection(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListConnectionsResult> listConnectionsAsync(ListConnectionsRequest request) {
        return this.listConnectionsAsync(request, null);
    }

    @Override
    public Future<ListConnectionsResult> listConnectionsAsync(ListConnectionsRequest request, final AsyncHandler<ListConnectionsRequest, ListConnectionsResult> asyncHandler) {
        final ListConnectionsRequest finalRequest = (ListConnectionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListConnectionsResult>(){

            @Override
            public ListConnectionsResult call() throws Exception {
                ListConnectionsResult result = null;
                try {
                    result = AWSCodeStarconnectionsAsyncClient.this.executeListConnections(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AWSCodeStarconnectionsAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AWSCodeStarconnectionsAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AWSCodeStarconnectionsAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

