/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codegurureviewer.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.codegurureviewer.model.CodeCommitRepository;
import com.amazonaws.services.codegurureviewer.model.S3Repository;
import com.amazonaws.services.codegurureviewer.model.ThirdPartySourceRepository;
import com.amazonaws.services.codegurureviewer.model.transform.RepositoryMarshaller;
import java.io.Serializable;

public class Repository
implements Serializable,
Cloneable,
StructuredPojo {
    private CodeCommitRepository codeCommit;
    private ThirdPartySourceRepository bitbucket;
    private ThirdPartySourceRepository gitHubEnterpriseServer;
    private S3Repository s3Bucket;

    public void setCodeCommit(CodeCommitRepository codeCommit) {
        this.codeCommit = codeCommit;
    }

    public CodeCommitRepository getCodeCommit() {
        return this.codeCommit;
    }

    public Repository withCodeCommit(CodeCommitRepository codeCommit) {
        this.setCodeCommit(codeCommit);
        return this;
    }

    public void setBitbucket(ThirdPartySourceRepository bitbucket) {
        this.bitbucket = bitbucket;
    }

    public ThirdPartySourceRepository getBitbucket() {
        return this.bitbucket;
    }

    public Repository withBitbucket(ThirdPartySourceRepository bitbucket) {
        this.setBitbucket(bitbucket);
        return this;
    }

    public void setGitHubEnterpriseServer(ThirdPartySourceRepository gitHubEnterpriseServer) {
        this.gitHubEnterpriseServer = gitHubEnterpriseServer;
    }

    public ThirdPartySourceRepository getGitHubEnterpriseServer() {
        return this.gitHubEnterpriseServer;
    }

    public Repository withGitHubEnterpriseServer(ThirdPartySourceRepository gitHubEnterpriseServer) {
        this.setGitHubEnterpriseServer(gitHubEnterpriseServer);
        return this;
    }

    public void setS3Bucket(S3Repository s3Bucket) {
        this.s3Bucket = s3Bucket;
    }

    public S3Repository getS3Bucket() {
        return this.s3Bucket;
    }

    public Repository withS3Bucket(S3Repository s3Bucket) {
        this.setS3Bucket(s3Bucket);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCodeCommit() != null) {
            sb.append("CodeCommit: ").append(this.getCodeCommit()).append(",");
        }
        if (this.getBitbucket() != null) {
            sb.append("Bitbucket: ").append(this.getBitbucket()).append(",");
        }
        if (this.getGitHubEnterpriseServer() != null) {
            sb.append("GitHubEnterpriseServer: ").append(this.getGitHubEnterpriseServer()).append(",");
        }
        if (this.getS3Bucket() != null) {
            sb.append("S3Bucket: ").append(this.getS3Bucket());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Repository)) {
            return false;
        }
        Repository other = (Repository)obj;
        if (other.getCodeCommit() == null ^ this.getCodeCommit() == null) {
            return false;
        }
        if (other.getCodeCommit() != null && !other.getCodeCommit().equals(this.getCodeCommit())) {
            return false;
        }
        if (other.getBitbucket() == null ^ this.getBitbucket() == null) {
            return false;
        }
        if (other.getBitbucket() != null && !other.getBitbucket().equals(this.getBitbucket())) {
            return false;
        }
        if (other.getGitHubEnterpriseServer() == null ^ this.getGitHubEnterpriseServer() == null) {
            return false;
        }
        if (other.getGitHubEnterpriseServer() != null && !other.getGitHubEnterpriseServer().equals(this.getGitHubEnterpriseServer())) {
            return false;
        }
        if (other.getS3Bucket() == null ^ this.getS3Bucket() == null) {
            return false;
        }
        return other.getS3Bucket() == null || other.getS3Bucket().equals(this.getS3Bucket());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCodeCommit() == null ? 0 : this.getCodeCommit().hashCode());
        hashCode = 31 * hashCode + (this.getBitbucket() == null ? 0 : this.getBitbucket().hashCode());
        hashCode = 31 * hashCode + (this.getGitHubEnterpriseServer() == null ? 0 : this.getGitHubEnterpriseServer().hashCode());
        hashCode = 31 * hashCode + (this.getS3Bucket() == null ? 0 : this.getS3Bucket().hashCode());
        return hashCode;
    }

    public Repository clone() {
        try {
            return (Repository)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RepositoryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

