/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codegurureviewer.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.codegurureviewer.model.AnalysisType;
import com.amazonaws.services.codegurureviewer.model.RepositoryAnalysis;
import com.amazonaws.services.codegurureviewer.model.transform.CodeReviewTypeMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CodeReviewType
implements Serializable,
Cloneable,
StructuredPojo {
    private RepositoryAnalysis repositoryAnalysis;
    private List<String> analysisTypes;

    public void setRepositoryAnalysis(RepositoryAnalysis repositoryAnalysis) {
        this.repositoryAnalysis = repositoryAnalysis;
    }

    public RepositoryAnalysis getRepositoryAnalysis() {
        return this.repositoryAnalysis;
    }

    public CodeReviewType withRepositoryAnalysis(RepositoryAnalysis repositoryAnalysis) {
        this.setRepositoryAnalysis(repositoryAnalysis);
        return this;
    }

    public List<String> getAnalysisTypes() {
        return this.analysisTypes;
    }

    public void setAnalysisTypes(Collection<String> analysisTypes) {
        if (analysisTypes == null) {
            this.analysisTypes = null;
            return;
        }
        this.analysisTypes = new ArrayList<String>(analysisTypes);
    }

    public CodeReviewType withAnalysisTypes(String ... analysisTypes) {
        if (this.analysisTypes == null) {
            this.setAnalysisTypes(new ArrayList<String>(analysisTypes.length));
        }
        for (String ele : analysisTypes) {
            this.analysisTypes.add(ele);
        }
        return this;
    }

    public CodeReviewType withAnalysisTypes(Collection<String> analysisTypes) {
        this.setAnalysisTypes(analysisTypes);
        return this;
    }

    public CodeReviewType withAnalysisTypes(AnalysisType ... analysisTypes) {
        ArrayList<String> analysisTypesCopy = new ArrayList<String>(analysisTypes.length);
        for (AnalysisType value : analysisTypes) {
            analysisTypesCopy.add(value.toString());
        }
        if (this.getAnalysisTypes() == null) {
            this.setAnalysisTypes(analysisTypesCopy);
        } else {
            this.getAnalysisTypes().addAll(analysisTypesCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRepositoryAnalysis() != null) {
            sb.append("RepositoryAnalysis: ").append(this.getRepositoryAnalysis()).append(",");
        }
        if (this.getAnalysisTypes() != null) {
            sb.append("AnalysisTypes: ").append(this.getAnalysisTypes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeReviewType)) {
            return false;
        }
        CodeReviewType other = (CodeReviewType)obj;
        if (other.getRepositoryAnalysis() == null ^ this.getRepositoryAnalysis() == null) {
            return false;
        }
        if (other.getRepositoryAnalysis() != null && !other.getRepositoryAnalysis().equals(this.getRepositoryAnalysis())) {
            return false;
        }
        if (other.getAnalysisTypes() == null ^ this.getAnalysisTypes() == null) {
            return false;
        }
        return other.getAnalysisTypes() == null || other.getAnalysisTypes().equals(this.getAnalysisTypes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRepositoryAnalysis() == null ? 0 : this.getRepositoryAnalysis().hashCode());
        hashCode = 31 * hashCode + (this.getAnalysisTypes() == null ? 0 : this.getAnalysisTypes().hashCode());
        return hashCode;
    }

    public CodeReviewType clone() {
        try {
            return (CodeReviewType)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CodeReviewTypeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

