/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.codegurureviewer.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codeguru-reviewer-2019-09-19/DescribeRecommendationFeedback"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class DescribeRecommendationFeedbackResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable,
        Cloneable {

    /**
     * <p>
     * The recommendation feedback given by the user.
     * </p>
     */
    private RecommendationFeedback recommendationFeedback;

    /**
     * <p>
     * The recommendation feedback given by the user.
     * </p>
     * 
     * @param recommendationFeedback
     *        The recommendation feedback given by the user.
     */

    public void setRecommendationFeedback(RecommendationFeedback recommendationFeedback) {
        this.recommendationFeedback = recommendationFeedback;
    }

    /**
     * <p>
     * The recommendation feedback given by the user.
     * </p>
     * 
     * @return The recommendation feedback given by the user.
     */

    public RecommendationFeedback getRecommendationFeedback() {
        return this.recommendationFeedback;
    }

    /**
     * <p>
     * The recommendation feedback given by the user.
     * </p>
     * 
     * @param recommendationFeedback
     *        The recommendation feedback given by the user.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeRecommendationFeedbackResult withRecommendationFeedback(RecommendationFeedback recommendationFeedback) {
        setRecommendationFeedback(recommendationFeedback);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getRecommendationFeedback() != null)
            sb.append("RecommendationFeedback: ").append(getRecommendationFeedback());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof DescribeRecommendationFeedbackResult == false)
            return false;
        DescribeRecommendationFeedbackResult other = (DescribeRecommendationFeedbackResult) obj;
        if (other.getRecommendationFeedback() == null ^ this.getRecommendationFeedback() == null)
            return false;
        if (other.getRecommendationFeedback() != null && other.getRecommendationFeedback().equals(this.getRecommendationFeedback()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getRecommendationFeedback() == null) ? 0 : getRecommendationFeedback().hashCode());
        return hashCode;
    }

    @Override
    public DescribeRecommendationFeedbackResult clone() {
        try {
            return (DescribeRecommendationFeedbackResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
