/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codegurureviewer.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.codegurureviewer.model.SourceCodeType;

@SdkInternalApi
public class SourceCodeTypeMarshaller {
    private static final MarshallingInfo<StructuredPojo> COMMITDIFF_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CommitDiff").build();
    private static final MarshallingInfo<StructuredPojo> REPOSITORYHEAD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RepositoryHead").build();
    private static final MarshallingInfo<StructuredPojo> BRANCHDIFF_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BranchDiff").build();
    private static final MarshallingInfo<StructuredPojo> S3BUCKETREPOSITORY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3BucketRepository").build();
    private static final MarshallingInfo<StructuredPojo> REQUESTMETADATA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RequestMetadata").build();
    private static final SourceCodeTypeMarshaller instance = new SourceCodeTypeMarshaller();

    public static SourceCodeTypeMarshaller getInstance() {
        return instance;
    }

    public void marshall(SourceCodeType sourceCodeType, ProtocolMarshaller protocolMarshaller) {
        if (sourceCodeType == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)sourceCodeType.getCommitDiff(), COMMITDIFF_BINDING);
            protocolMarshaller.marshall((Object)sourceCodeType.getRepositoryHead(), REPOSITORYHEAD_BINDING);
            protocolMarshaller.marshall((Object)sourceCodeType.getBranchDiff(), BRANCHDIFF_BINDING);
            protocolMarshaller.marshall((Object)sourceCodeType.getS3BucketRepository(), S3BUCKETREPOSITORY_BINDING);
            protocolMarshaller.marshall((Object)sourceCodeType.getRequestMetadata(), REQUESTMETADATA_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

