/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codegurureviewer.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.codegurureviewer.model.S3RepositoryDetails;
import com.amazonaws.services.codegurureviewer.model.transform.S3BucketRepositoryMarshaller;
import java.io.Serializable;

public class S3BucketRepository
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private S3RepositoryDetails details;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public S3BucketRepository withName(String name) {
        this.setName(name);
        return this;
    }

    public void setDetails(S3RepositoryDetails details) {
        this.details = details;
    }

    public S3RepositoryDetails getDetails() {
        return this.details;
    }

    public S3BucketRepository withDetails(S3RepositoryDetails details) {
        this.setDetails(details);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getDetails() != null) {
            sb.append("Details: ").append(this.getDetails());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3BucketRepository)) {
            return false;
        }
        S3BucketRepository other = (S3BucketRepository)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getDetails() == null ^ this.getDetails() == null) {
            return false;
        }
        return other.getDetails() == null || other.getDetails().equals(this.getDetails());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getDetails() == null ? 0 : this.getDetails().hashCode());
        return hashCode;
    }

    public S3BucketRepository clone() {
        try {
            return (S3BucketRepository)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        S3BucketRepositoryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

