/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codegurureviewer;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.codegurureviewer.AmazonCodeGuruReviewer;
import com.amazonaws.services.codegurureviewer.AmazonCodeGuruReviewerClientBuilder;
import com.amazonaws.services.codegurureviewer.model.AmazonCodeGuruReviewerException;
import com.amazonaws.services.codegurureviewer.model.AssociateRepositoryRequest;
import com.amazonaws.services.codegurureviewer.model.AssociateRepositoryResult;
import com.amazonaws.services.codegurureviewer.model.CreateCodeReviewRequest;
import com.amazonaws.services.codegurureviewer.model.CreateCodeReviewResult;
import com.amazonaws.services.codegurureviewer.model.DescribeCodeReviewRequest;
import com.amazonaws.services.codegurureviewer.model.DescribeCodeReviewResult;
import com.amazonaws.services.codegurureviewer.model.DescribeRecommendationFeedbackRequest;
import com.amazonaws.services.codegurureviewer.model.DescribeRecommendationFeedbackResult;
import com.amazonaws.services.codegurureviewer.model.DescribeRepositoryAssociationRequest;
import com.amazonaws.services.codegurureviewer.model.DescribeRepositoryAssociationResult;
import com.amazonaws.services.codegurureviewer.model.DisassociateRepositoryRequest;
import com.amazonaws.services.codegurureviewer.model.DisassociateRepositoryResult;
import com.amazonaws.services.codegurureviewer.model.ListCodeReviewsRequest;
import com.amazonaws.services.codegurureviewer.model.ListCodeReviewsResult;
import com.amazonaws.services.codegurureviewer.model.ListRecommendationFeedbackRequest;
import com.amazonaws.services.codegurureviewer.model.ListRecommendationFeedbackResult;
import com.amazonaws.services.codegurureviewer.model.ListRecommendationsRequest;
import com.amazonaws.services.codegurureviewer.model.ListRecommendationsResult;
import com.amazonaws.services.codegurureviewer.model.ListRepositoryAssociationsRequest;
import com.amazonaws.services.codegurureviewer.model.ListRepositoryAssociationsResult;
import com.amazonaws.services.codegurureviewer.model.ListTagsForResourceRequest;
import com.amazonaws.services.codegurureviewer.model.ListTagsForResourceResult;
import com.amazonaws.services.codegurureviewer.model.PutRecommendationFeedbackRequest;
import com.amazonaws.services.codegurureviewer.model.PutRecommendationFeedbackResult;
import com.amazonaws.services.codegurureviewer.model.TagResourceRequest;
import com.amazonaws.services.codegurureviewer.model.TagResourceResult;
import com.amazonaws.services.codegurureviewer.model.UntagResourceRequest;
import com.amazonaws.services.codegurureviewer.model.UntagResourceResult;
import com.amazonaws.services.codegurureviewer.model.transform.AccessDeniedExceptionUnmarshaller;
import com.amazonaws.services.codegurureviewer.model.transform.AssociateRepositoryRequestProtocolMarshaller;
import com.amazonaws.services.codegurureviewer.model.transform.AssociateRepositoryResultJsonUnmarshaller;
import com.amazonaws.services.codegurureviewer.model.transform.ConflictExceptionUnmarshaller;
import com.amazonaws.services.codegurureviewer.model.transform.CreateCodeReviewRequestProtocolMarshaller;
import com.amazonaws.services.codegurureviewer.model.transform.CreateCodeReviewResultJsonUnmarshaller;
import com.amazonaws.services.codegurureviewer.model.transform.DescribeCodeReviewRequestProtocolMarshaller;
import com.amazonaws.services.codegurureviewer.model.transform.DescribeCodeReviewResultJsonUnmarshaller;
import com.amazonaws.services.codegurureviewer.model.transform.DescribeRecommendationFeedbackRequestProtocolMarshaller;
import com.amazonaws.services.codegurureviewer.model.transform.DescribeRecommendationFeedbackResultJsonUnmarshaller;
import com.amazonaws.services.codegurureviewer.model.transform.DescribeRepositoryAssociationRequestProtocolMarshaller;
import com.amazonaws.services.codegurureviewer.model.transform.DescribeRepositoryAssociationResultJsonUnmarshaller;
import com.amazonaws.services.codegurureviewer.model.transform.DisassociateRepositoryRequestProtocolMarshaller;
import com.amazonaws.services.codegurureviewer.model.transform.DisassociateRepositoryResultJsonUnmarshaller;
import com.amazonaws.services.codegurureviewer.model.transform.InternalServerExceptionUnmarshaller;
import com.amazonaws.services.codegurureviewer.model.transform.ListCodeReviewsRequestProtocolMarshaller;
import com.amazonaws.services.codegurureviewer.model.transform.ListCodeReviewsResultJsonUnmarshaller;
import com.amazonaws.services.codegurureviewer.model.transform.ListRecommendationFeedbackRequestProtocolMarshaller;
import com.amazonaws.services.codegurureviewer.model.transform.ListRecommendationFeedbackResultJsonUnmarshaller;
import com.amazonaws.services.codegurureviewer.model.transform.ListRecommendationsRequestProtocolMarshaller;
import com.amazonaws.services.codegurureviewer.model.transform.ListRecommendationsResultJsonUnmarshaller;
import com.amazonaws.services.codegurureviewer.model.transform.ListRepositoryAssociationsRequestProtocolMarshaller;
import com.amazonaws.services.codegurureviewer.model.transform.ListRepositoryAssociationsResultJsonUnmarshaller;
import com.amazonaws.services.codegurureviewer.model.transform.ListTagsForResourceRequestProtocolMarshaller;
import com.amazonaws.services.codegurureviewer.model.transform.ListTagsForResourceResultJsonUnmarshaller;
import com.amazonaws.services.codegurureviewer.model.transform.NotFoundExceptionUnmarshaller;
import com.amazonaws.services.codegurureviewer.model.transform.PutRecommendationFeedbackRequestProtocolMarshaller;
import com.amazonaws.services.codegurureviewer.model.transform.PutRecommendationFeedbackResultJsonUnmarshaller;
import com.amazonaws.services.codegurureviewer.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.codegurureviewer.model.transform.TagResourceRequestProtocolMarshaller;
import com.amazonaws.services.codegurureviewer.model.transform.TagResourceResultJsonUnmarshaller;
import com.amazonaws.services.codegurureviewer.model.transform.ThrottlingExceptionUnmarshaller;
import com.amazonaws.services.codegurureviewer.model.transform.UntagResourceRequestProtocolMarshaller;
import com.amazonaws.services.codegurureviewer.model.transform.UntagResourceResultJsonUnmarshaller;
import com.amazonaws.services.codegurureviewer.model.transform.ValidationExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AmazonCodeGuruReviewerClient
extends AmazonWebServiceClient
implements AmazonCodeGuruReviewer {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonCodeGuruReviewer.class);
    private static final String DEFAULT_SIGNING_NAME = "codeguru-reviewer";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)AccessDeniedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConflictException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ConflictExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ThrottlingException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ThrottlingExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ValidationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)NotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalServerExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AmazonCodeGuruReviewerException.class));

    public static AmazonCodeGuruReviewerClientBuilder builder() {
        return AmazonCodeGuruReviewerClientBuilder.standard();
    }

    AmazonCodeGuruReviewerClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AmazonCodeGuruReviewerClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("codeguru-reviewer.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/codegurureviewer/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/codegurureviewer/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public AssociateRepositoryResult associateRepository(AssociateRepositoryRequest request) {
        request = (AssociateRepositoryRequest)this.beforeClientExecution(request);
        return this.executeAssociateRepository(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final AssociateRepositoryResult executeAssociateRepository(AssociateRepositoryRequest associateRepositoryRequest) {
        ExecutionContext executionContext = this.createExecutionContext(associateRepositoryRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AssociateRepositoryRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AssociateRepositoryRequestProtocolMarshaller(protocolFactory).marshall((AssociateRepositoryRequest)super.beforeMarshalling((AmazonWebServiceRequest)associateRepositoryRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CodeGuru Reviewer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"AssociateRepository");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new AssociateRepositoryResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            AssociateRepositoryResult associateRepositoryResult = (AssociateRepositoryResult)response.getAwsResponse();
            return associateRepositoryResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateCodeReviewResult createCodeReview(CreateCodeReviewRequest request) {
        request = (CreateCodeReviewRequest)this.beforeClientExecution(request);
        return this.executeCreateCodeReview(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateCodeReviewResult executeCreateCodeReview(CreateCodeReviewRequest createCodeReviewRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createCodeReviewRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateCodeReviewRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateCodeReviewRequestProtocolMarshaller(protocolFactory).marshall((CreateCodeReviewRequest)super.beforeMarshalling((AmazonWebServiceRequest)createCodeReviewRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CodeGuru Reviewer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateCodeReview");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateCodeReviewResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateCodeReviewResult createCodeReviewResult = (CreateCodeReviewResult)response.getAwsResponse();
            return createCodeReviewResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeCodeReviewResult describeCodeReview(DescribeCodeReviewRequest request) {
        request = (DescribeCodeReviewRequest)this.beforeClientExecution(request);
        return this.executeDescribeCodeReview(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeCodeReviewResult executeDescribeCodeReview(DescribeCodeReviewRequest describeCodeReviewRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeCodeReviewRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeCodeReviewRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeCodeReviewRequestProtocolMarshaller(protocolFactory).marshall((DescribeCodeReviewRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeCodeReviewRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CodeGuru Reviewer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeCodeReview");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeCodeReviewResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeCodeReviewResult describeCodeReviewResult = (DescribeCodeReviewResult)response.getAwsResponse();
            return describeCodeReviewResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeRecommendationFeedbackResult describeRecommendationFeedback(DescribeRecommendationFeedbackRequest request) {
        request = (DescribeRecommendationFeedbackRequest)this.beforeClientExecution(request);
        return this.executeDescribeRecommendationFeedback(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeRecommendationFeedbackResult executeDescribeRecommendationFeedback(DescribeRecommendationFeedbackRequest describeRecommendationFeedbackRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeRecommendationFeedbackRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeRecommendationFeedbackRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeRecommendationFeedbackRequestProtocolMarshaller(protocolFactory).marshall((DescribeRecommendationFeedbackRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeRecommendationFeedbackRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CodeGuru Reviewer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeRecommendationFeedback");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeRecommendationFeedbackResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeRecommendationFeedbackResult describeRecommendationFeedbackResult = (DescribeRecommendationFeedbackResult)response.getAwsResponse();
            return describeRecommendationFeedbackResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeRepositoryAssociationResult describeRepositoryAssociation(DescribeRepositoryAssociationRequest request) {
        request = (DescribeRepositoryAssociationRequest)this.beforeClientExecution(request);
        return this.executeDescribeRepositoryAssociation(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeRepositoryAssociationResult executeDescribeRepositoryAssociation(DescribeRepositoryAssociationRequest describeRepositoryAssociationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeRepositoryAssociationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeRepositoryAssociationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeRepositoryAssociationRequestProtocolMarshaller(protocolFactory).marshall((DescribeRepositoryAssociationRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeRepositoryAssociationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CodeGuru Reviewer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeRepositoryAssociation");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeRepositoryAssociationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeRepositoryAssociationResult describeRepositoryAssociationResult = (DescribeRepositoryAssociationResult)response.getAwsResponse();
            return describeRepositoryAssociationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DisassociateRepositoryResult disassociateRepository(DisassociateRepositoryRequest request) {
        request = (DisassociateRepositoryRequest)this.beforeClientExecution(request);
        return this.executeDisassociateRepository(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DisassociateRepositoryResult executeDisassociateRepository(DisassociateRepositoryRequest disassociateRepositoryRequest) {
        ExecutionContext executionContext = this.createExecutionContext(disassociateRepositoryRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DisassociateRepositoryRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DisassociateRepositoryRequestProtocolMarshaller(protocolFactory).marshall((DisassociateRepositoryRequest)super.beforeMarshalling((AmazonWebServiceRequest)disassociateRepositoryRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CodeGuru Reviewer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DisassociateRepository");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DisassociateRepositoryResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DisassociateRepositoryResult disassociateRepositoryResult = (DisassociateRepositoryResult)response.getAwsResponse();
            return disassociateRepositoryResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListCodeReviewsResult listCodeReviews(ListCodeReviewsRequest request) {
        request = (ListCodeReviewsRequest)this.beforeClientExecution(request);
        return this.executeListCodeReviews(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListCodeReviewsResult executeListCodeReviews(ListCodeReviewsRequest listCodeReviewsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listCodeReviewsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListCodeReviewsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListCodeReviewsRequestProtocolMarshaller(protocolFactory).marshall((ListCodeReviewsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listCodeReviewsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CodeGuru Reviewer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListCodeReviews");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListCodeReviewsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListCodeReviewsResult listCodeReviewsResult = (ListCodeReviewsResult)response.getAwsResponse();
            return listCodeReviewsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListRecommendationFeedbackResult listRecommendationFeedback(ListRecommendationFeedbackRequest request) {
        request = (ListRecommendationFeedbackRequest)this.beforeClientExecution(request);
        return this.executeListRecommendationFeedback(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListRecommendationFeedbackResult executeListRecommendationFeedback(ListRecommendationFeedbackRequest listRecommendationFeedbackRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listRecommendationFeedbackRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListRecommendationFeedbackRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListRecommendationFeedbackRequestProtocolMarshaller(protocolFactory).marshall((ListRecommendationFeedbackRequest)super.beforeMarshalling((AmazonWebServiceRequest)listRecommendationFeedbackRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CodeGuru Reviewer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListRecommendationFeedback");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListRecommendationFeedbackResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListRecommendationFeedbackResult listRecommendationFeedbackResult = (ListRecommendationFeedbackResult)response.getAwsResponse();
            return listRecommendationFeedbackResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListRecommendationsResult listRecommendations(ListRecommendationsRequest request) {
        request = (ListRecommendationsRequest)this.beforeClientExecution(request);
        return this.executeListRecommendations(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListRecommendationsResult executeListRecommendations(ListRecommendationsRequest listRecommendationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listRecommendationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListRecommendationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListRecommendationsRequestProtocolMarshaller(protocolFactory).marshall((ListRecommendationsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listRecommendationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CodeGuru Reviewer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListRecommendations");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListRecommendationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListRecommendationsResult listRecommendationsResult = (ListRecommendationsResult)response.getAwsResponse();
            return listRecommendationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListRepositoryAssociationsResult listRepositoryAssociations(ListRepositoryAssociationsRequest request) {
        request = (ListRepositoryAssociationsRequest)this.beforeClientExecution(request);
        return this.executeListRepositoryAssociations(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListRepositoryAssociationsResult executeListRepositoryAssociations(ListRepositoryAssociationsRequest listRepositoryAssociationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listRepositoryAssociationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListRepositoryAssociationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListRepositoryAssociationsRequestProtocolMarshaller(protocolFactory).marshall((ListRepositoryAssociationsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listRepositoryAssociationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CodeGuru Reviewer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListRepositoryAssociations");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListRepositoryAssociationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListRepositoryAssociationsResult listRepositoryAssociationsResult = (ListRepositoryAssociationsResult)response.getAwsResponse();
            return listRepositoryAssociationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        request = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executeListTagsForResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsForResourceResult executeListTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForResourceRequestProtocolMarshaller(protocolFactory).marshall((ListTagsForResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTagsForResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CodeGuru Reviewer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTagsForResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTagsForResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsForResourceResult listTagsForResourceResult = (ListTagsForResourceResult)response.getAwsResponse();
            return listTagsForResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutRecommendationFeedbackResult putRecommendationFeedback(PutRecommendationFeedbackRequest request) {
        request = (PutRecommendationFeedbackRequest)this.beforeClientExecution(request);
        return this.executePutRecommendationFeedback(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutRecommendationFeedbackResult executePutRecommendationFeedback(PutRecommendationFeedbackRequest putRecommendationFeedbackRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putRecommendationFeedbackRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutRecommendationFeedbackRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutRecommendationFeedbackRequestProtocolMarshaller(protocolFactory).marshall((PutRecommendationFeedbackRequest)super.beforeMarshalling((AmazonWebServiceRequest)putRecommendationFeedbackRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CodeGuru Reviewer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PutRecommendationFeedback");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutRecommendationFeedbackResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutRecommendationFeedbackResult putRecommendationFeedbackResult = (PutRecommendationFeedbackResult)response.getAwsResponse();
            return putRecommendationFeedbackResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        request = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executeTagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TagResourceResult executeTagResource(TagResourceRequest tagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(tagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TagResourceRequestProtocolMarshaller(protocolFactory).marshall((TagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)tagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CodeGuru Reviewer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"TagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TagResourceResult tagResourceResult = (TagResourceResult)response.getAwsResponse();
            return tagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        request = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executeUntagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UntagResourceResult executeUntagResource(UntagResourceRequest untagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(untagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UntagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UntagResourceRequestProtocolMarshaller(protocolFactory).marshall((UntagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)untagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CodeGuru Reviewer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UntagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UntagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UntagResourceResult untagResourceResult = (UntagResourceResult)response.getAwsResponse();
            return untagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }
}

