/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codegurureviewer;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.codegurureviewer.AmazonCodeGuruReviewerAsync;
import com.amazonaws.services.codegurureviewer.AmazonCodeGuruReviewerAsyncClientBuilder;
import com.amazonaws.services.codegurureviewer.AmazonCodeGuruReviewerClient;
import com.amazonaws.services.codegurureviewer.model.AssociateRepositoryRequest;
import com.amazonaws.services.codegurureviewer.model.AssociateRepositoryResult;
import com.amazonaws.services.codegurureviewer.model.DescribeRepositoryAssociationRequest;
import com.amazonaws.services.codegurureviewer.model.DescribeRepositoryAssociationResult;
import com.amazonaws.services.codegurureviewer.model.DisassociateRepositoryRequest;
import com.amazonaws.services.codegurureviewer.model.DisassociateRepositoryResult;
import com.amazonaws.services.codegurureviewer.model.ListRepositoryAssociationsRequest;
import com.amazonaws.services.codegurureviewer.model.ListRepositoryAssociationsResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonCodeGuruReviewerAsyncClient
extends AmazonCodeGuruReviewerClient
implements AmazonCodeGuruReviewerAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonCodeGuruReviewerAsyncClientBuilder asyncBuilder() {
        return AmazonCodeGuruReviewerAsyncClientBuilder.standard();
    }

    AmazonCodeGuruReviewerAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super((AwsSyncClientParams)asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<AssociateRepositoryResult> associateRepositoryAsync(AssociateRepositoryRequest request) {
        return this.associateRepositoryAsync(request, null);
    }

    @Override
    public Future<AssociateRepositoryResult> associateRepositoryAsync(AssociateRepositoryRequest request, final AsyncHandler<AssociateRepositoryRequest, AssociateRepositoryResult> asyncHandler) {
        final AssociateRepositoryRequest finalRequest = (AssociateRepositoryRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AssociateRepositoryResult>(){

            @Override
            public AssociateRepositoryResult call() throws Exception {
                AssociateRepositoryResult result = null;
                try {
                    result = AmazonCodeGuruReviewerAsyncClient.this.executeAssociateRepository(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeRepositoryAssociationResult> describeRepositoryAssociationAsync(DescribeRepositoryAssociationRequest request) {
        return this.describeRepositoryAssociationAsync(request, null);
    }

    @Override
    public Future<DescribeRepositoryAssociationResult> describeRepositoryAssociationAsync(DescribeRepositoryAssociationRequest request, final AsyncHandler<DescribeRepositoryAssociationRequest, DescribeRepositoryAssociationResult> asyncHandler) {
        final DescribeRepositoryAssociationRequest finalRequest = (DescribeRepositoryAssociationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeRepositoryAssociationResult>(){

            @Override
            public DescribeRepositoryAssociationResult call() throws Exception {
                DescribeRepositoryAssociationResult result = null;
                try {
                    result = AmazonCodeGuruReviewerAsyncClient.this.executeDescribeRepositoryAssociation(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DisassociateRepositoryResult> disassociateRepositoryAsync(DisassociateRepositoryRequest request) {
        return this.disassociateRepositoryAsync(request, null);
    }

    @Override
    public Future<DisassociateRepositoryResult> disassociateRepositoryAsync(DisassociateRepositoryRequest request, final AsyncHandler<DisassociateRepositoryRequest, DisassociateRepositoryResult> asyncHandler) {
        final DisassociateRepositoryRequest finalRequest = (DisassociateRepositoryRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DisassociateRepositoryResult>(){

            @Override
            public DisassociateRepositoryResult call() throws Exception {
                DisassociateRepositoryResult result = null;
                try {
                    result = AmazonCodeGuruReviewerAsyncClient.this.executeDisassociateRepository(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListRepositoryAssociationsResult> listRepositoryAssociationsAsync(ListRepositoryAssociationsRequest request) {
        return this.listRepositoryAssociationsAsync(request, null);
    }

    @Override
    public Future<ListRepositoryAssociationsResult> listRepositoryAssociationsAsync(ListRepositoryAssociationsRequest request, final AsyncHandler<ListRepositoryAssociationsRequest, ListRepositoryAssociationsResult> asyncHandler) {
        final ListRepositoryAssociationsRequest finalRequest = (ListRepositoryAssociationsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListRepositoryAssociationsResult>(){

            @Override
            public ListRepositoryAssociationsResult call() throws Exception {
                ListRepositoryAssociationsResult result = null;
                try {
                    result = AmazonCodeGuruReviewerAsyncClient.this.executeListRepositoryAssociations(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

