/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codeguruprofiler.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.codeguruprofiler.model.MetricType;
import com.amazonaws.services.codeguruprofiler.model.transform.FrameMetricMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class FrameMetric
implements Serializable,
Cloneable,
StructuredPojo {
    private String frameName;
    private List<String> threadStates;
    private String type;

    public void setFrameName(String frameName) {
        this.frameName = frameName;
    }

    public String getFrameName() {
        return this.frameName;
    }

    public FrameMetric withFrameName(String frameName) {
        this.setFrameName(frameName);
        return this;
    }

    public List<String> getThreadStates() {
        return this.threadStates;
    }

    public void setThreadStates(Collection<String> threadStates) {
        if (threadStates == null) {
            this.threadStates = null;
            return;
        }
        this.threadStates = new ArrayList<String>(threadStates);
    }

    public FrameMetric withThreadStates(String ... threadStates) {
        if (this.threadStates == null) {
            this.setThreadStates(new ArrayList<String>(threadStates.length));
        }
        for (String ele : threadStates) {
            this.threadStates.add(ele);
        }
        return this;
    }

    public FrameMetric withThreadStates(Collection<String> threadStates) {
        this.setThreadStates(threadStates);
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public FrameMetric withType(String type) {
        this.setType(type);
        return this;
    }

    public FrameMetric withType(MetricType type) {
        this.type = type.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFrameName() != null) {
            sb.append("FrameName: ").append(this.getFrameName()).append(",");
        }
        if (this.getThreadStates() != null) {
            sb.append("ThreadStates: ").append(this.getThreadStates()).append(",");
        }
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FrameMetric)) {
            return false;
        }
        FrameMetric other = (FrameMetric)obj;
        if (other.getFrameName() == null ^ this.getFrameName() == null) {
            return false;
        }
        if (other.getFrameName() != null && !other.getFrameName().equals(this.getFrameName())) {
            return false;
        }
        if (other.getThreadStates() == null ^ this.getThreadStates() == null) {
            return false;
        }
        if (other.getThreadStates() != null && !other.getThreadStates().equals(this.getThreadStates())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        return other.getType() == null || other.getType().equals(this.getType());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFrameName() == null ? 0 : this.getFrameName().hashCode());
        hashCode = 31 * hashCode + (this.getThreadStates() == null ? 0 : this.getThreadStates().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        return hashCode;
    }

    public FrameMetric clone() {
        try {
            return (FrameMetric)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FrameMetricMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

