/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codeguruprofiler.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.codeguruprofiler.model.EventPublisher;
import com.amazonaws.services.codeguruprofiler.model.transform.ChannelMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Channel
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> eventPublishers;
    private String id;
    private String uri;

    public List<String> getEventPublishers() {
        return this.eventPublishers;
    }

    public void setEventPublishers(Collection<String> eventPublishers) {
        if (eventPublishers == null) {
            this.eventPublishers = null;
            return;
        }
        this.eventPublishers = new ArrayList<String>(eventPublishers);
    }

    public Channel withEventPublishers(String ... eventPublishers) {
        if (this.eventPublishers == null) {
            this.setEventPublishers(new ArrayList<String>(eventPublishers.length));
        }
        for (String ele : eventPublishers) {
            this.eventPublishers.add(ele);
        }
        return this;
    }

    public Channel withEventPublishers(Collection<String> eventPublishers) {
        this.setEventPublishers(eventPublishers);
        return this;
    }

    public Channel withEventPublishers(EventPublisher ... eventPublishers) {
        ArrayList<String> eventPublishersCopy = new ArrayList<String>(eventPublishers.length);
        for (EventPublisher value : eventPublishers) {
            eventPublishersCopy.add(value.toString());
        }
        if (this.getEventPublishers() == null) {
            this.setEventPublishers(eventPublishersCopy);
        } else {
            this.getEventPublishers().addAll(eventPublishersCopy);
        }
        return this;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public Channel withId(String id) {
        this.setId(id);
        return this;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getUri() {
        return this.uri;
    }

    public Channel withUri(String uri) {
        this.setUri(uri);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEventPublishers() != null) {
            sb.append("EventPublishers: ").append(this.getEventPublishers()).append(",");
        }
        if (this.getId() != null) {
            sb.append("Id: ").append(this.getId()).append(",");
        }
        if (this.getUri() != null) {
            sb.append("Uri: ").append(this.getUri());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Channel)) {
            return false;
        }
        Channel other = (Channel)obj;
        if (other.getEventPublishers() == null ^ this.getEventPublishers() == null) {
            return false;
        }
        if (other.getEventPublishers() != null && !other.getEventPublishers().equals(this.getEventPublishers())) {
            return false;
        }
        if (other.getId() == null ^ this.getId() == null) {
            return false;
        }
        if (other.getId() != null && !other.getId().equals(this.getId())) {
            return false;
        }
        if (other.getUri() == null ^ this.getUri() == null) {
            return false;
        }
        return other.getUri() == null || other.getUri().equals(this.getUri());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEventPublishers() == null ? 0 : this.getEventPublishers().hashCode());
        hashCode = 31 * hashCode + (this.getId() == null ? 0 : this.getId().hashCode());
        hashCode = 31 * hashCode + (this.getUri() == null ? 0 : this.getUri().hashCode());
        return hashCode;
    }

    public Channel clone() {
        try {
            return (Channel)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ChannelMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

