/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codeguruprofiler.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.codeguruprofiler.model.Recommendation;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class RecommendationMarshaller {
    private static final MarshallingInfo<Integer> ALLMATCHESCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("allMatchesCount").build();
    private static final MarshallingInfo<Double> ALLMATCHESSUM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("allMatchesSum").build();
    private static final MarshallingInfo<Date> ENDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("endTime").timestampFormat("iso8601").build();
    private static final MarshallingInfo<StructuredPojo> PATTERN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("pattern").build();
    private static final MarshallingInfo<Date> STARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("startTime").timestampFormat("iso8601").build();
    private static final MarshallingInfo<List> TOPMATCHES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("topMatches").build();
    private static final RecommendationMarshaller instance = new RecommendationMarshaller();

    public static RecommendationMarshaller getInstance() {
        return instance;
    }

    public void marshall(Recommendation recommendation, ProtocolMarshaller protocolMarshaller) {
        if (recommendation == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)recommendation.getAllMatchesCount(), ALLMATCHESCOUNT_BINDING);
            protocolMarshaller.marshall((Object)recommendation.getAllMatchesSum(), ALLMATCHESSUM_BINDING);
            protocolMarshaller.marshall((Object)recommendation.getEndTime(), ENDTIME_BINDING);
            protocolMarshaller.marshall((Object)recommendation.getPattern(), PATTERN_BINDING);
            protocolMarshaller.marshall((Object)recommendation.getStartTime(), STARTTIME_BINDING);
            protocolMarshaller.marshall(recommendation.getTopMatches(), TOPMATCHES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

