/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codeguruprofiler.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.codeguruprofiler.model.transform.AgentConfigurationMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class AgentConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private Map<String, String> agentParameters;
    private Integer periodInSeconds;
    private Boolean shouldProfile;

    public Map<String, String> getAgentParameters() {
        return this.agentParameters;
    }

    public void setAgentParameters(Map<String, String> agentParameters) {
        this.agentParameters = agentParameters;
    }

    public AgentConfiguration withAgentParameters(Map<String, String> agentParameters) {
        this.setAgentParameters(agentParameters);
        return this;
    }

    public AgentConfiguration addAgentParametersEntry(String key, String value) {
        if (null == this.agentParameters) {
            this.agentParameters = new HashMap<String, String>();
        }
        if (this.agentParameters.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.agentParameters.put(key, value);
        return this;
    }

    public AgentConfiguration clearAgentParametersEntries() {
        this.agentParameters = null;
        return this;
    }

    public void setPeriodInSeconds(Integer periodInSeconds) {
        this.periodInSeconds = periodInSeconds;
    }

    public Integer getPeriodInSeconds() {
        return this.periodInSeconds;
    }

    public AgentConfiguration withPeriodInSeconds(Integer periodInSeconds) {
        this.setPeriodInSeconds(periodInSeconds);
        return this;
    }

    public void setShouldProfile(Boolean shouldProfile) {
        this.shouldProfile = shouldProfile;
    }

    public Boolean getShouldProfile() {
        return this.shouldProfile;
    }

    public AgentConfiguration withShouldProfile(Boolean shouldProfile) {
        this.setShouldProfile(shouldProfile);
        return this;
    }

    public Boolean isShouldProfile() {
        return this.shouldProfile;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAgentParameters() != null) {
            sb.append("AgentParameters: ").append(this.getAgentParameters()).append(",");
        }
        if (this.getPeriodInSeconds() != null) {
            sb.append("PeriodInSeconds: ").append(this.getPeriodInSeconds()).append(",");
        }
        if (this.getShouldProfile() != null) {
            sb.append("ShouldProfile: ").append(this.getShouldProfile());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AgentConfiguration)) {
            return false;
        }
        AgentConfiguration other = (AgentConfiguration)obj;
        if (other.getAgentParameters() == null ^ this.getAgentParameters() == null) {
            return false;
        }
        if (other.getAgentParameters() != null && !other.getAgentParameters().equals(this.getAgentParameters())) {
            return false;
        }
        if (other.getPeriodInSeconds() == null ^ this.getPeriodInSeconds() == null) {
            return false;
        }
        if (other.getPeriodInSeconds() != null && !other.getPeriodInSeconds().equals(this.getPeriodInSeconds())) {
            return false;
        }
        if (other.getShouldProfile() == null ^ this.getShouldProfile() == null) {
            return false;
        }
        return other.getShouldProfile() == null || other.getShouldProfile().equals(this.getShouldProfile());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAgentParameters() == null ? 0 : this.getAgentParameters().hashCode());
        hashCode = 31 * hashCode + (this.getPeriodInSeconds() == null ? 0 : this.getPeriodInSeconds().hashCode());
        hashCode = 31 * hashCode + (this.getShouldProfile() == null ? 0 : this.getShouldProfile().hashCode());
        return hashCode;
    }

    public AgentConfiguration clone() {
        try {
            return (AgentConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AgentConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

