/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codeguruprofiler.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.codeguruprofiler.model.Channel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AddNotificationChannelsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private List<Channel> channels;
    private String profilingGroupName;

    public List<Channel> getChannels() {
        return this.channels;
    }

    public void setChannels(Collection<Channel> channels) {
        if (channels == null) {
            this.channels = null;
            return;
        }
        this.channels = new ArrayList<Channel>(channels);
    }

    public AddNotificationChannelsRequest withChannels(Channel ... channels) {
        if (this.channels == null) {
            this.setChannels(new ArrayList<Channel>(channels.length));
        }
        for (Channel ele : channels) {
            this.channels.add(ele);
        }
        return this;
    }

    public AddNotificationChannelsRequest withChannels(Collection<Channel> channels) {
        this.setChannels(channels);
        return this;
    }

    public void setProfilingGroupName(String profilingGroupName) {
        this.profilingGroupName = profilingGroupName;
    }

    public String getProfilingGroupName() {
        return this.profilingGroupName;
    }

    public AddNotificationChannelsRequest withProfilingGroupName(String profilingGroupName) {
        this.setProfilingGroupName(profilingGroupName);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getChannels() != null) {
            sb.append("Channels: ").append(this.getChannels()).append(",");
        }
        if (this.getProfilingGroupName() != null) {
            sb.append("ProfilingGroupName: ").append(this.getProfilingGroupName());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddNotificationChannelsRequest)) {
            return false;
        }
        AddNotificationChannelsRequest other = (AddNotificationChannelsRequest)obj;
        if (other.getChannels() == null ^ this.getChannels() == null) {
            return false;
        }
        if (other.getChannels() != null && !other.getChannels().equals(this.getChannels())) {
            return false;
        }
        if (other.getProfilingGroupName() == null ^ this.getProfilingGroupName() == null) {
            return false;
        }
        return other.getProfilingGroupName() == null || other.getProfilingGroupName().equals(this.getProfilingGroupName());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getChannels() == null ? 0 : this.getChannels().hashCode());
        hashCode = 31 * hashCode + (this.getProfilingGroupName() == null ? 0 : this.getProfilingGroupName().hashCode());
        return hashCode;
    }

    public AddNotificationChannelsRequest clone() {
        return (AddNotificationChannelsRequest)super.clone();
    }
}

