/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codecommit.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.codecommit.model.BatchGetRepositoriesError;
import com.amazonaws.services.codecommit.model.RepositoryMetadata;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BatchGetRepositoriesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<RepositoryMetadata> repositories;
    private List<String> repositoriesNotFound;
    private List<BatchGetRepositoriesError> errors;

    public List<RepositoryMetadata> getRepositories() {
        return this.repositories;
    }

    public void setRepositories(Collection<RepositoryMetadata> repositories) {
        if (repositories == null) {
            this.repositories = null;
            return;
        }
        this.repositories = new ArrayList<RepositoryMetadata>(repositories);
    }

    public BatchGetRepositoriesResult withRepositories(RepositoryMetadata ... repositories) {
        if (this.repositories == null) {
            this.setRepositories(new ArrayList<RepositoryMetadata>(repositories.length));
        }
        for (RepositoryMetadata ele : repositories) {
            this.repositories.add(ele);
        }
        return this;
    }

    public BatchGetRepositoriesResult withRepositories(Collection<RepositoryMetadata> repositories) {
        this.setRepositories(repositories);
        return this;
    }

    public List<String> getRepositoriesNotFound() {
        return this.repositoriesNotFound;
    }

    public void setRepositoriesNotFound(Collection<String> repositoriesNotFound) {
        if (repositoriesNotFound == null) {
            this.repositoriesNotFound = null;
            return;
        }
        this.repositoriesNotFound = new ArrayList<String>(repositoriesNotFound);
    }

    public BatchGetRepositoriesResult withRepositoriesNotFound(String ... repositoriesNotFound) {
        if (this.repositoriesNotFound == null) {
            this.setRepositoriesNotFound(new ArrayList<String>(repositoriesNotFound.length));
        }
        for (String ele : repositoriesNotFound) {
            this.repositoriesNotFound.add(ele);
        }
        return this;
    }

    public BatchGetRepositoriesResult withRepositoriesNotFound(Collection<String> repositoriesNotFound) {
        this.setRepositoriesNotFound(repositoriesNotFound);
        return this;
    }

    public List<BatchGetRepositoriesError> getErrors() {
        return this.errors;
    }

    public void setErrors(Collection<BatchGetRepositoriesError> errors) {
        if (errors == null) {
            this.errors = null;
            return;
        }
        this.errors = new ArrayList<BatchGetRepositoriesError>(errors);
    }

    public BatchGetRepositoriesResult withErrors(BatchGetRepositoriesError ... errors) {
        if (this.errors == null) {
            this.setErrors(new ArrayList<BatchGetRepositoriesError>(errors.length));
        }
        for (BatchGetRepositoriesError ele : errors) {
            this.errors.add(ele);
        }
        return this;
    }

    public BatchGetRepositoriesResult withErrors(Collection<BatchGetRepositoriesError> errors) {
        this.setErrors(errors);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRepositories() != null) {
            sb.append("Repositories: ").append(this.getRepositories()).append(",");
        }
        if (this.getRepositoriesNotFound() != null) {
            sb.append("RepositoriesNotFound: ").append(this.getRepositoriesNotFound()).append(",");
        }
        if (this.getErrors() != null) {
            sb.append("Errors: ").append(this.getErrors());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetRepositoriesResult)) {
            return false;
        }
        BatchGetRepositoriesResult other = (BatchGetRepositoriesResult)obj;
        if (other.getRepositories() == null ^ this.getRepositories() == null) {
            return false;
        }
        if (other.getRepositories() != null && !other.getRepositories().equals(this.getRepositories())) {
            return false;
        }
        if (other.getRepositoriesNotFound() == null ^ this.getRepositoriesNotFound() == null) {
            return false;
        }
        if (other.getRepositoriesNotFound() != null && !other.getRepositoriesNotFound().equals(this.getRepositoriesNotFound())) {
            return false;
        }
        if (other.getErrors() == null ^ this.getErrors() == null) {
            return false;
        }
        return other.getErrors() == null || other.getErrors().equals(this.getErrors());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRepositories() == null ? 0 : this.getRepositories().hashCode());
        hashCode = 31 * hashCode + (this.getRepositoriesNotFound() == null ? 0 : this.getRepositoriesNotFound().hashCode());
        hashCode = 31 * hashCode + (this.getErrors() == null ? 0 : this.getErrors().hashCode());
        return hashCode;
    }

    public BatchGetRepositoriesResult clone() {
        try {
            return (BatchGetRepositoriesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

