/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codecommit.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.codecommit.model.FileVersion;
import java.util.List;

@SdkInternalApi
public class FileVersionMarshaller {
    private static final MarshallingInfo<StructuredPojo> COMMIT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("commit").build();
    private static final MarshallingInfo<String> BLOBID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("blobId").build();
    private static final MarshallingInfo<String> PATH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("path").build();
    private static final MarshallingInfo<List> REVISIONCHILDREN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("revisionChildren").build();
    private static final FileVersionMarshaller instance = new FileVersionMarshaller();

    public static FileVersionMarshaller getInstance() {
        return instance;
    }

    public void marshall(FileVersion fileVersion, ProtocolMarshaller protocolMarshaller) {
        if (fileVersion == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)fileVersion.getCommit(), COMMIT_BINDING);
            protocolMarshaller.marshall((Object)fileVersion.getBlobId(), BLOBID_BINDING);
            protocolMarshaller.marshall((Object)fileVersion.getPath(), PATH_BINDING);
            protocolMarshaller.marshall(fileVersion.getRevisionChildren(), REVISIONCHILDREN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

