/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codebuild.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.codebuild.model.FleetScalingType;
import com.amazonaws.services.codebuild.model.TargetTrackingScalingConfiguration;
import com.amazonaws.services.codebuild.model.transform.ScalingConfigurationOutputMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ScalingConfigurationOutput
implements Serializable,
Cloneable,
StructuredPojo {
    private String scalingType;
    private List<TargetTrackingScalingConfiguration> targetTrackingScalingConfigs;
    private Integer maxCapacity;
    private Integer desiredCapacity;

    public void setScalingType(String scalingType) {
        this.scalingType = scalingType;
    }

    public String getScalingType() {
        return this.scalingType;
    }

    public ScalingConfigurationOutput withScalingType(String scalingType) {
        this.setScalingType(scalingType);
        return this;
    }

    public ScalingConfigurationOutput withScalingType(FleetScalingType scalingType) {
        this.scalingType = scalingType.toString();
        return this;
    }

    public List<TargetTrackingScalingConfiguration> getTargetTrackingScalingConfigs() {
        return this.targetTrackingScalingConfigs;
    }

    public void setTargetTrackingScalingConfigs(Collection<TargetTrackingScalingConfiguration> targetTrackingScalingConfigs) {
        if (targetTrackingScalingConfigs == null) {
            this.targetTrackingScalingConfigs = null;
            return;
        }
        this.targetTrackingScalingConfigs = new ArrayList<TargetTrackingScalingConfiguration>(targetTrackingScalingConfigs);
    }

    public ScalingConfigurationOutput withTargetTrackingScalingConfigs(TargetTrackingScalingConfiguration ... targetTrackingScalingConfigs) {
        if (this.targetTrackingScalingConfigs == null) {
            this.setTargetTrackingScalingConfigs(new ArrayList<TargetTrackingScalingConfiguration>(targetTrackingScalingConfigs.length));
        }
        for (TargetTrackingScalingConfiguration ele : targetTrackingScalingConfigs) {
            this.targetTrackingScalingConfigs.add(ele);
        }
        return this;
    }

    public ScalingConfigurationOutput withTargetTrackingScalingConfigs(Collection<TargetTrackingScalingConfiguration> targetTrackingScalingConfigs) {
        this.setTargetTrackingScalingConfigs(targetTrackingScalingConfigs);
        return this;
    }

    public void setMaxCapacity(Integer maxCapacity) {
        this.maxCapacity = maxCapacity;
    }

    public Integer getMaxCapacity() {
        return this.maxCapacity;
    }

    public ScalingConfigurationOutput withMaxCapacity(Integer maxCapacity) {
        this.setMaxCapacity(maxCapacity);
        return this;
    }

    public void setDesiredCapacity(Integer desiredCapacity) {
        this.desiredCapacity = desiredCapacity;
    }

    public Integer getDesiredCapacity() {
        return this.desiredCapacity;
    }

    public ScalingConfigurationOutput withDesiredCapacity(Integer desiredCapacity) {
        this.setDesiredCapacity(desiredCapacity);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getScalingType() != null) {
            sb.append("ScalingType: ").append(this.getScalingType()).append(",");
        }
        if (this.getTargetTrackingScalingConfigs() != null) {
            sb.append("TargetTrackingScalingConfigs: ").append(this.getTargetTrackingScalingConfigs()).append(",");
        }
        if (this.getMaxCapacity() != null) {
            sb.append("MaxCapacity: ").append(this.getMaxCapacity()).append(",");
        }
        if (this.getDesiredCapacity() != null) {
            sb.append("DesiredCapacity: ").append(this.getDesiredCapacity());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScalingConfigurationOutput)) {
            return false;
        }
        ScalingConfigurationOutput other = (ScalingConfigurationOutput)obj;
        if (other.getScalingType() == null ^ this.getScalingType() == null) {
            return false;
        }
        if (other.getScalingType() != null && !other.getScalingType().equals(this.getScalingType())) {
            return false;
        }
        if (other.getTargetTrackingScalingConfigs() == null ^ this.getTargetTrackingScalingConfigs() == null) {
            return false;
        }
        if (other.getTargetTrackingScalingConfigs() != null && !other.getTargetTrackingScalingConfigs().equals(this.getTargetTrackingScalingConfigs())) {
            return false;
        }
        if (other.getMaxCapacity() == null ^ this.getMaxCapacity() == null) {
            return false;
        }
        if (other.getMaxCapacity() != null && !other.getMaxCapacity().equals(this.getMaxCapacity())) {
            return false;
        }
        if (other.getDesiredCapacity() == null ^ this.getDesiredCapacity() == null) {
            return false;
        }
        return other.getDesiredCapacity() == null || other.getDesiredCapacity().equals(this.getDesiredCapacity());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getScalingType() == null ? 0 : this.getScalingType().hashCode());
        hashCode = 31 * hashCode + (this.getTargetTrackingScalingConfigs() == null ? 0 : this.getTargetTrackingScalingConfigs().hashCode());
        hashCode = 31 * hashCode + (this.getMaxCapacity() == null ? 0 : this.getMaxCapacity().hashCode());
        hashCode = 31 * hashCode + (this.getDesiredCapacity() == null ? 0 : this.getDesiredCapacity().hashCode());
        return hashCode;
    }

    public ScalingConfigurationOutput clone() {
        try {
            return (ScalingConfigurationOutput)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ScalingConfigurationOutputMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

