/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codebuild.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.codebuild.model.ResolvedArtifact;
import com.amazonaws.services.codebuild.model.StatusType;
import com.amazonaws.services.codebuild.model.transform.BuildSummaryMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class BuildSummary
implements Serializable,
Cloneable,
StructuredPojo {
    private String arn;
    private Date requestedOn;
    private String buildStatus;
    private ResolvedArtifact primaryArtifact;
    private List<ResolvedArtifact> secondaryArtifacts;

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public BuildSummary withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public void setRequestedOn(Date requestedOn) {
        this.requestedOn = requestedOn;
    }

    public Date getRequestedOn() {
        return this.requestedOn;
    }

    public BuildSummary withRequestedOn(Date requestedOn) {
        this.setRequestedOn(requestedOn);
        return this;
    }

    public void setBuildStatus(String buildStatus) {
        this.buildStatus = buildStatus;
    }

    public String getBuildStatus() {
        return this.buildStatus;
    }

    public BuildSummary withBuildStatus(String buildStatus) {
        this.setBuildStatus(buildStatus);
        return this;
    }

    public BuildSummary withBuildStatus(StatusType buildStatus) {
        this.buildStatus = buildStatus.toString();
        return this;
    }

    public void setPrimaryArtifact(ResolvedArtifact primaryArtifact) {
        this.primaryArtifact = primaryArtifact;
    }

    public ResolvedArtifact getPrimaryArtifact() {
        return this.primaryArtifact;
    }

    public BuildSummary withPrimaryArtifact(ResolvedArtifact primaryArtifact) {
        this.setPrimaryArtifact(primaryArtifact);
        return this;
    }

    public List<ResolvedArtifact> getSecondaryArtifacts() {
        return this.secondaryArtifacts;
    }

    public void setSecondaryArtifacts(Collection<ResolvedArtifact> secondaryArtifacts) {
        if (secondaryArtifacts == null) {
            this.secondaryArtifacts = null;
            return;
        }
        this.secondaryArtifacts = new ArrayList<ResolvedArtifact>(secondaryArtifacts);
    }

    public BuildSummary withSecondaryArtifacts(ResolvedArtifact ... secondaryArtifacts) {
        if (this.secondaryArtifacts == null) {
            this.setSecondaryArtifacts(new ArrayList<ResolvedArtifact>(secondaryArtifacts.length));
        }
        for (ResolvedArtifact ele : secondaryArtifacts) {
            this.secondaryArtifacts.add(ele);
        }
        return this;
    }

    public BuildSummary withSecondaryArtifacts(Collection<ResolvedArtifact> secondaryArtifacts) {
        this.setSecondaryArtifacts(secondaryArtifacts);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getRequestedOn() != null) {
            sb.append("RequestedOn: ").append(this.getRequestedOn()).append(",");
        }
        if (this.getBuildStatus() != null) {
            sb.append("BuildStatus: ").append(this.getBuildStatus()).append(",");
        }
        if (this.getPrimaryArtifact() != null) {
            sb.append("PrimaryArtifact: ").append(this.getPrimaryArtifact()).append(",");
        }
        if (this.getSecondaryArtifacts() != null) {
            sb.append("SecondaryArtifacts: ").append(this.getSecondaryArtifacts());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BuildSummary)) {
            return false;
        }
        BuildSummary other = (BuildSummary)obj;
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getRequestedOn() == null ^ this.getRequestedOn() == null) {
            return false;
        }
        if (other.getRequestedOn() != null && !other.getRequestedOn().equals(this.getRequestedOn())) {
            return false;
        }
        if (other.getBuildStatus() == null ^ this.getBuildStatus() == null) {
            return false;
        }
        if (other.getBuildStatus() != null && !other.getBuildStatus().equals(this.getBuildStatus())) {
            return false;
        }
        if (other.getPrimaryArtifact() == null ^ this.getPrimaryArtifact() == null) {
            return false;
        }
        if (other.getPrimaryArtifact() != null && !other.getPrimaryArtifact().equals(this.getPrimaryArtifact())) {
            return false;
        }
        if (other.getSecondaryArtifacts() == null ^ this.getSecondaryArtifacts() == null) {
            return false;
        }
        return other.getSecondaryArtifacts() == null || other.getSecondaryArtifacts().equals(this.getSecondaryArtifacts());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getRequestedOn() == null ? 0 : this.getRequestedOn().hashCode());
        hashCode = 31 * hashCode + (this.getBuildStatus() == null ? 0 : this.getBuildStatus().hashCode());
        hashCode = 31 * hashCode + (this.getPrimaryArtifact() == null ? 0 : this.getPrimaryArtifact().hashCode());
        hashCode = 31 * hashCode + (this.getSecondaryArtifacts() == null ? 0 : this.getSecondaryArtifacts().hashCode());
        return hashCode;
    }

    public BuildSummary clone() {
        try {
            return (BuildSummary)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BuildSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

