/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codebuild.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.codebuild.model.LogsConfig;
import com.amazonaws.services.codebuild.model.ProjectArtifacts;
import com.amazonaws.services.codebuild.model.ProjectBadge;
import com.amazonaws.services.codebuild.model.ProjectBuildBatchConfig;
import com.amazonaws.services.codebuild.model.ProjectCache;
import com.amazonaws.services.codebuild.model.ProjectEnvironment;
import com.amazonaws.services.codebuild.model.ProjectFileSystemLocation;
import com.amazonaws.services.codebuild.model.ProjectSource;
import com.amazonaws.services.codebuild.model.ProjectSourceVersion;
import com.amazonaws.services.codebuild.model.Tag;
import com.amazonaws.services.codebuild.model.VpcConfig;
import com.amazonaws.services.codebuild.model.Webhook;
import com.amazonaws.services.codebuild.model.transform.ProjectMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class Project
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private String arn;
    private String description;
    private ProjectSource source;
    private List<ProjectSource> secondarySources;
    private String sourceVersion;
    private List<ProjectSourceVersion> secondarySourceVersions;
    private ProjectArtifacts artifacts;
    private List<ProjectArtifacts> secondaryArtifacts;
    private ProjectCache cache;
    private ProjectEnvironment environment;
    private String serviceRole;
    private Integer timeoutInMinutes;
    private Integer queuedTimeoutInMinutes;
    private String encryptionKey;
    private List<Tag> tags;
    private Date created;
    private Date lastModified;
    private Webhook webhook;
    private VpcConfig vpcConfig;
    private ProjectBadge badge;
    private LogsConfig logsConfig;
    private List<ProjectFileSystemLocation> fileSystemLocations;
    private ProjectBuildBatchConfig buildBatchConfig;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Project withName(String name) {
        this.setName(name);
        return this;
    }

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public Project withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public Project withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setSource(ProjectSource source) {
        this.source = source;
    }

    public ProjectSource getSource() {
        return this.source;
    }

    public Project withSource(ProjectSource source) {
        this.setSource(source);
        return this;
    }

    public List<ProjectSource> getSecondarySources() {
        return this.secondarySources;
    }

    public void setSecondarySources(Collection<ProjectSource> secondarySources) {
        if (secondarySources == null) {
            this.secondarySources = null;
            return;
        }
        this.secondarySources = new ArrayList<ProjectSource>(secondarySources);
    }

    public Project withSecondarySources(ProjectSource ... secondarySources) {
        if (this.secondarySources == null) {
            this.setSecondarySources(new ArrayList<ProjectSource>(secondarySources.length));
        }
        for (ProjectSource ele : secondarySources) {
            this.secondarySources.add(ele);
        }
        return this;
    }

    public Project withSecondarySources(Collection<ProjectSource> secondarySources) {
        this.setSecondarySources(secondarySources);
        return this;
    }

    public void setSourceVersion(String sourceVersion) {
        this.sourceVersion = sourceVersion;
    }

    public String getSourceVersion() {
        return this.sourceVersion;
    }

    public Project withSourceVersion(String sourceVersion) {
        this.setSourceVersion(sourceVersion);
        return this;
    }

    public List<ProjectSourceVersion> getSecondarySourceVersions() {
        return this.secondarySourceVersions;
    }

    public void setSecondarySourceVersions(Collection<ProjectSourceVersion> secondarySourceVersions) {
        if (secondarySourceVersions == null) {
            this.secondarySourceVersions = null;
            return;
        }
        this.secondarySourceVersions = new ArrayList<ProjectSourceVersion>(secondarySourceVersions);
    }

    public Project withSecondarySourceVersions(ProjectSourceVersion ... secondarySourceVersions) {
        if (this.secondarySourceVersions == null) {
            this.setSecondarySourceVersions(new ArrayList<ProjectSourceVersion>(secondarySourceVersions.length));
        }
        for (ProjectSourceVersion ele : secondarySourceVersions) {
            this.secondarySourceVersions.add(ele);
        }
        return this;
    }

    public Project withSecondarySourceVersions(Collection<ProjectSourceVersion> secondarySourceVersions) {
        this.setSecondarySourceVersions(secondarySourceVersions);
        return this;
    }

    public void setArtifacts(ProjectArtifacts artifacts) {
        this.artifacts = artifacts;
    }

    public ProjectArtifacts getArtifacts() {
        return this.artifacts;
    }

    public Project withArtifacts(ProjectArtifacts artifacts) {
        this.setArtifacts(artifacts);
        return this;
    }

    public List<ProjectArtifacts> getSecondaryArtifacts() {
        return this.secondaryArtifacts;
    }

    public void setSecondaryArtifacts(Collection<ProjectArtifacts> secondaryArtifacts) {
        if (secondaryArtifacts == null) {
            this.secondaryArtifacts = null;
            return;
        }
        this.secondaryArtifacts = new ArrayList<ProjectArtifacts>(secondaryArtifacts);
    }

    public Project withSecondaryArtifacts(ProjectArtifacts ... secondaryArtifacts) {
        if (this.secondaryArtifacts == null) {
            this.setSecondaryArtifacts(new ArrayList<ProjectArtifacts>(secondaryArtifacts.length));
        }
        for (ProjectArtifacts ele : secondaryArtifacts) {
            this.secondaryArtifacts.add(ele);
        }
        return this;
    }

    public Project withSecondaryArtifacts(Collection<ProjectArtifacts> secondaryArtifacts) {
        this.setSecondaryArtifacts(secondaryArtifacts);
        return this;
    }

    public void setCache(ProjectCache cache) {
        this.cache = cache;
    }

    public ProjectCache getCache() {
        return this.cache;
    }

    public Project withCache(ProjectCache cache) {
        this.setCache(cache);
        return this;
    }

    public void setEnvironment(ProjectEnvironment environment) {
        this.environment = environment;
    }

    public ProjectEnvironment getEnvironment() {
        return this.environment;
    }

    public Project withEnvironment(ProjectEnvironment environment) {
        this.setEnvironment(environment);
        return this;
    }

    public void setServiceRole(String serviceRole) {
        this.serviceRole = serviceRole;
    }

    public String getServiceRole() {
        return this.serviceRole;
    }

    public Project withServiceRole(String serviceRole) {
        this.setServiceRole(serviceRole);
        return this;
    }

    public void setTimeoutInMinutes(Integer timeoutInMinutes) {
        this.timeoutInMinutes = timeoutInMinutes;
    }

    public Integer getTimeoutInMinutes() {
        return this.timeoutInMinutes;
    }

    public Project withTimeoutInMinutes(Integer timeoutInMinutes) {
        this.setTimeoutInMinutes(timeoutInMinutes);
        return this;
    }

    public void setQueuedTimeoutInMinutes(Integer queuedTimeoutInMinutes) {
        this.queuedTimeoutInMinutes = queuedTimeoutInMinutes;
    }

    public Integer getQueuedTimeoutInMinutes() {
        return this.queuedTimeoutInMinutes;
    }

    public Project withQueuedTimeoutInMinutes(Integer queuedTimeoutInMinutes) {
        this.setQueuedTimeoutInMinutes(queuedTimeoutInMinutes);
        return this;
    }

    public void setEncryptionKey(String encryptionKey) {
        this.encryptionKey = encryptionKey;
    }

    public String getEncryptionKey() {
        return this.encryptionKey;
    }

    public Project withEncryptionKey(String encryptionKey) {
        this.setEncryptionKey(encryptionKey);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public Project withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public Project withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public Date getCreated() {
        return this.created;
    }

    public Project withCreated(Date created) {
        this.setCreated(created);
        return this;
    }

    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public Project withLastModified(Date lastModified) {
        this.setLastModified(lastModified);
        return this;
    }

    public void setWebhook(Webhook webhook) {
        this.webhook = webhook;
    }

    public Webhook getWebhook() {
        return this.webhook;
    }

    public Project withWebhook(Webhook webhook) {
        this.setWebhook(webhook);
        return this;
    }

    public void setVpcConfig(VpcConfig vpcConfig) {
        this.vpcConfig = vpcConfig;
    }

    public VpcConfig getVpcConfig() {
        return this.vpcConfig;
    }

    public Project withVpcConfig(VpcConfig vpcConfig) {
        this.setVpcConfig(vpcConfig);
        return this;
    }

    public void setBadge(ProjectBadge badge) {
        this.badge = badge;
    }

    public ProjectBadge getBadge() {
        return this.badge;
    }

    public Project withBadge(ProjectBadge badge) {
        this.setBadge(badge);
        return this;
    }

    public void setLogsConfig(LogsConfig logsConfig) {
        this.logsConfig = logsConfig;
    }

    public LogsConfig getLogsConfig() {
        return this.logsConfig;
    }

    public Project withLogsConfig(LogsConfig logsConfig) {
        this.setLogsConfig(logsConfig);
        return this;
    }

    public List<ProjectFileSystemLocation> getFileSystemLocations() {
        return this.fileSystemLocations;
    }

    public void setFileSystemLocations(Collection<ProjectFileSystemLocation> fileSystemLocations) {
        if (fileSystemLocations == null) {
            this.fileSystemLocations = null;
            return;
        }
        this.fileSystemLocations = new ArrayList<ProjectFileSystemLocation>(fileSystemLocations);
    }

    public Project withFileSystemLocations(ProjectFileSystemLocation ... fileSystemLocations) {
        if (this.fileSystemLocations == null) {
            this.setFileSystemLocations(new ArrayList<ProjectFileSystemLocation>(fileSystemLocations.length));
        }
        for (ProjectFileSystemLocation ele : fileSystemLocations) {
            this.fileSystemLocations.add(ele);
        }
        return this;
    }

    public Project withFileSystemLocations(Collection<ProjectFileSystemLocation> fileSystemLocations) {
        this.setFileSystemLocations(fileSystemLocations);
        return this;
    }

    public void setBuildBatchConfig(ProjectBuildBatchConfig buildBatchConfig) {
        this.buildBatchConfig = buildBatchConfig;
    }

    public ProjectBuildBatchConfig getBuildBatchConfig() {
        return this.buildBatchConfig;
    }

    public Project withBuildBatchConfig(ProjectBuildBatchConfig buildBatchConfig) {
        this.setBuildBatchConfig(buildBatchConfig);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getSource() != null) {
            sb.append("Source: ").append(this.getSource()).append(",");
        }
        if (this.getSecondarySources() != null) {
            sb.append("SecondarySources: ").append(this.getSecondarySources()).append(",");
        }
        if (this.getSourceVersion() != null) {
            sb.append("SourceVersion: ").append(this.getSourceVersion()).append(",");
        }
        if (this.getSecondarySourceVersions() != null) {
            sb.append("SecondarySourceVersions: ").append(this.getSecondarySourceVersions()).append(",");
        }
        if (this.getArtifacts() != null) {
            sb.append("Artifacts: ").append(this.getArtifacts()).append(",");
        }
        if (this.getSecondaryArtifacts() != null) {
            sb.append("SecondaryArtifacts: ").append(this.getSecondaryArtifacts()).append(",");
        }
        if (this.getCache() != null) {
            sb.append("Cache: ").append(this.getCache()).append(",");
        }
        if (this.getEnvironment() != null) {
            sb.append("Environment: ").append(this.getEnvironment()).append(",");
        }
        if (this.getServiceRole() != null) {
            sb.append("ServiceRole: ").append(this.getServiceRole()).append(",");
        }
        if (this.getTimeoutInMinutes() != null) {
            sb.append("TimeoutInMinutes: ").append(this.getTimeoutInMinutes()).append(",");
        }
        if (this.getQueuedTimeoutInMinutes() != null) {
            sb.append("QueuedTimeoutInMinutes: ").append(this.getQueuedTimeoutInMinutes()).append(",");
        }
        if (this.getEncryptionKey() != null) {
            sb.append("EncryptionKey: ").append(this.getEncryptionKey()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getCreated() != null) {
            sb.append("Created: ").append(this.getCreated()).append(",");
        }
        if (this.getLastModified() != null) {
            sb.append("LastModified: ").append(this.getLastModified()).append(",");
        }
        if (this.getWebhook() != null) {
            sb.append("Webhook: ").append(this.getWebhook()).append(",");
        }
        if (this.getVpcConfig() != null) {
            sb.append("VpcConfig: ").append(this.getVpcConfig()).append(",");
        }
        if (this.getBadge() != null) {
            sb.append("Badge: ").append(this.getBadge()).append(",");
        }
        if (this.getLogsConfig() != null) {
            sb.append("LogsConfig: ").append(this.getLogsConfig()).append(",");
        }
        if (this.getFileSystemLocations() != null) {
            sb.append("FileSystemLocations: ").append(this.getFileSystemLocations()).append(",");
        }
        if (this.getBuildBatchConfig() != null) {
            sb.append("BuildBatchConfig: ").append(this.getBuildBatchConfig());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Project)) {
            return false;
        }
        Project other = (Project)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getSource() == null ^ this.getSource() == null) {
            return false;
        }
        if (other.getSource() != null && !other.getSource().equals(this.getSource())) {
            return false;
        }
        if (other.getSecondarySources() == null ^ this.getSecondarySources() == null) {
            return false;
        }
        if (other.getSecondarySources() != null && !other.getSecondarySources().equals(this.getSecondarySources())) {
            return false;
        }
        if (other.getSourceVersion() == null ^ this.getSourceVersion() == null) {
            return false;
        }
        if (other.getSourceVersion() != null && !other.getSourceVersion().equals(this.getSourceVersion())) {
            return false;
        }
        if (other.getSecondarySourceVersions() == null ^ this.getSecondarySourceVersions() == null) {
            return false;
        }
        if (other.getSecondarySourceVersions() != null && !other.getSecondarySourceVersions().equals(this.getSecondarySourceVersions())) {
            return false;
        }
        if (other.getArtifacts() == null ^ this.getArtifacts() == null) {
            return false;
        }
        if (other.getArtifacts() != null && !other.getArtifacts().equals(this.getArtifacts())) {
            return false;
        }
        if (other.getSecondaryArtifacts() == null ^ this.getSecondaryArtifacts() == null) {
            return false;
        }
        if (other.getSecondaryArtifacts() != null && !other.getSecondaryArtifacts().equals(this.getSecondaryArtifacts())) {
            return false;
        }
        if (other.getCache() == null ^ this.getCache() == null) {
            return false;
        }
        if (other.getCache() != null && !other.getCache().equals(this.getCache())) {
            return false;
        }
        if (other.getEnvironment() == null ^ this.getEnvironment() == null) {
            return false;
        }
        if (other.getEnvironment() != null && !other.getEnvironment().equals(this.getEnvironment())) {
            return false;
        }
        if (other.getServiceRole() == null ^ this.getServiceRole() == null) {
            return false;
        }
        if (other.getServiceRole() != null && !other.getServiceRole().equals(this.getServiceRole())) {
            return false;
        }
        if (other.getTimeoutInMinutes() == null ^ this.getTimeoutInMinutes() == null) {
            return false;
        }
        if (other.getTimeoutInMinutes() != null && !other.getTimeoutInMinutes().equals(this.getTimeoutInMinutes())) {
            return false;
        }
        if (other.getQueuedTimeoutInMinutes() == null ^ this.getQueuedTimeoutInMinutes() == null) {
            return false;
        }
        if (other.getQueuedTimeoutInMinutes() != null && !other.getQueuedTimeoutInMinutes().equals(this.getQueuedTimeoutInMinutes())) {
            return false;
        }
        if (other.getEncryptionKey() == null ^ this.getEncryptionKey() == null) {
            return false;
        }
        if (other.getEncryptionKey() != null && !other.getEncryptionKey().equals(this.getEncryptionKey())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getCreated() == null ^ this.getCreated() == null) {
            return false;
        }
        if (other.getCreated() != null && !other.getCreated().equals(this.getCreated())) {
            return false;
        }
        if (other.getLastModified() == null ^ this.getLastModified() == null) {
            return false;
        }
        if (other.getLastModified() != null && !other.getLastModified().equals(this.getLastModified())) {
            return false;
        }
        if (other.getWebhook() == null ^ this.getWebhook() == null) {
            return false;
        }
        if (other.getWebhook() != null && !other.getWebhook().equals(this.getWebhook())) {
            return false;
        }
        if (other.getVpcConfig() == null ^ this.getVpcConfig() == null) {
            return false;
        }
        if (other.getVpcConfig() != null && !other.getVpcConfig().equals(this.getVpcConfig())) {
            return false;
        }
        if (other.getBadge() == null ^ this.getBadge() == null) {
            return false;
        }
        if (other.getBadge() != null && !other.getBadge().equals(this.getBadge())) {
            return false;
        }
        if (other.getLogsConfig() == null ^ this.getLogsConfig() == null) {
            return false;
        }
        if (other.getLogsConfig() != null && !other.getLogsConfig().equals(this.getLogsConfig())) {
            return false;
        }
        if (other.getFileSystemLocations() == null ^ this.getFileSystemLocations() == null) {
            return false;
        }
        if (other.getFileSystemLocations() != null && !other.getFileSystemLocations().equals(this.getFileSystemLocations())) {
            return false;
        }
        if (other.getBuildBatchConfig() == null ^ this.getBuildBatchConfig() == null) {
            return false;
        }
        return other.getBuildBatchConfig() == null || other.getBuildBatchConfig().equals(this.getBuildBatchConfig());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getSource() == null ? 0 : this.getSource().hashCode());
        hashCode = 31 * hashCode + (this.getSecondarySources() == null ? 0 : this.getSecondarySources().hashCode());
        hashCode = 31 * hashCode + (this.getSourceVersion() == null ? 0 : this.getSourceVersion().hashCode());
        hashCode = 31 * hashCode + (this.getSecondarySourceVersions() == null ? 0 : this.getSecondarySourceVersions().hashCode());
        hashCode = 31 * hashCode + (this.getArtifacts() == null ? 0 : this.getArtifacts().hashCode());
        hashCode = 31 * hashCode + (this.getSecondaryArtifacts() == null ? 0 : this.getSecondaryArtifacts().hashCode());
        hashCode = 31 * hashCode + (this.getCache() == null ? 0 : this.getCache().hashCode());
        hashCode = 31 * hashCode + (this.getEnvironment() == null ? 0 : this.getEnvironment().hashCode());
        hashCode = 31 * hashCode + (this.getServiceRole() == null ? 0 : this.getServiceRole().hashCode());
        hashCode = 31 * hashCode + (this.getTimeoutInMinutes() == null ? 0 : this.getTimeoutInMinutes().hashCode());
        hashCode = 31 * hashCode + (this.getQueuedTimeoutInMinutes() == null ? 0 : this.getQueuedTimeoutInMinutes().hashCode());
        hashCode = 31 * hashCode + (this.getEncryptionKey() == null ? 0 : this.getEncryptionKey().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getCreated() == null ? 0 : this.getCreated().hashCode());
        hashCode = 31 * hashCode + (this.getLastModified() == null ? 0 : this.getLastModified().hashCode());
        hashCode = 31 * hashCode + (this.getWebhook() == null ? 0 : this.getWebhook().hashCode());
        hashCode = 31 * hashCode + (this.getVpcConfig() == null ? 0 : this.getVpcConfig().hashCode());
        hashCode = 31 * hashCode + (this.getBadge() == null ? 0 : this.getBadge().hashCode());
        hashCode = 31 * hashCode + (this.getLogsConfig() == null ? 0 : this.getLogsConfig().hashCode());
        hashCode = 31 * hashCode + (this.getFileSystemLocations() == null ? 0 : this.getFileSystemLocations().hashCode());
        hashCode = 31 * hashCode + (this.getBuildBatchConfig() == null ? 0 : this.getBuildBatchConfig().hashCode());
        return hashCode;
    }

    public Project clone() {
        try {
            return (Project)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ProjectMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

