/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codebuild.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.codebuild.model.BuildSummary;
import com.amazonaws.services.codebuild.model.transform.BuildGroupMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BuildGroup
implements Serializable,
Cloneable,
StructuredPojo {
    private String identifier;
    private List<String> dependsOn;
    private Boolean ignoreFailure;
    private BuildSummary currentBuildSummary;
    private List<BuildSummary> priorBuildSummaryList;

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public BuildGroup withIdentifier(String identifier) {
        this.setIdentifier(identifier);
        return this;
    }

    public List<String> getDependsOn() {
        return this.dependsOn;
    }

    public void setDependsOn(Collection<String> dependsOn) {
        if (dependsOn == null) {
            this.dependsOn = null;
            return;
        }
        this.dependsOn = new ArrayList<String>(dependsOn);
    }

    public BuildGroup withDependsOn(String ... dependsOn) {
        if (this.dependsOn == null) {
            this.setDependsOn(new ArrayList<String>(dependsOn.length));
        }
        for (String ele : dependsOn) {
            this.dependsOn.add(ele);
        }
        return this;
    }

    public BuildGroup withDependsOn(Collection<String> dependsOn) {
        this.setDependsOn(dependsOn);
        return this;
    }

    public void setIgnoreFailure(Boolean ignoreFailure) {
        this.ignoreFailure = ignoreFailure;
    }

    public Boolean getIgnoreFailure() {
        return this.ignoreFailure;
    }

    public BuildGroup withIgnoreFailure(Boolean ignoreFailure) {
        this.setIgnoreFailure(ignoreFailure);
        return this;
    }

    public Boolean isIgnoreFailure() {
        return this.ignoreFailure;
    }

    public void setCurrentBuildSummary(BuildSummary currentBuildSummary) {
        this.currentBuildSummary = currentBuildSummary;
    }

    public BuildSummary getCurrentBuildSummary() {
        return this.currentBuildSummary;
    }

    public BuildGroup withCurrentBuildSummary(BuildSummary currentBuildSummary) {
        this.setCurrentBuildSummary(currentBuildSummary);
        return this;
    }

    public List<BuildSummary> getPriorBuildSummaryList() {
        return this.priorBuildSummaryList;
    }

    public void setPriorBuildSummaryList(Collection<BuildSummary> priorBuildSummaryList) {
        if (priorBuildSummaryList == null) {
            this.priorBuildSummaryList = null;
            return;
        }
        this.priorBuildSummaryList = new ArrayList<BuildSummary>(priorBuildSummaryList);
    }

    public BuildGroup withPriorBuildSummaryList(BuildSummary ... priorBuildSummaryList) {
        if (this.priorBuildSummaryList == null) {
            this.setPriorBuildSummaryList(new ArrayList<BuildSummary>(priorBuildSummaryList.length));
        }
        for (BuildSummary ele : priorBuildSummaryList) {
            this.priorBuildSummaryList.add(ele);
        }
        return this;
    }

    public BuildGroup withPriorBuildSummaryList(Collection<BuildSummary> priorBuildSummaryList) {
        this.setPriorBuildSummaryList(priorBuildSummaryList);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getIdentifier() != null) {
            sb.append("Identifier: ").append(this.getIdentifier()).append(",");
        }
        if (this.getDependsOn() != null) {
            sb.append("DependsOn: ").append(this.getDependsOn()).append(",");
        }
        if (this.getIgnoreFailure() != null) {
            sb.append("IgnoreFailure: ").append(this.getIgnoreFailure()).append(",");
        }
        if (this.getCurrentBuildSummary() != null) {
            sb.append("CurrentBuildSummary: ").append(this.getCurrentBuildSummary()).append(",");
        }
        if (this.getPriorBuildSummaryList() != null) {
            sb.append("PriorBuildSummaryList: ").append(this.getPriorBuildSummaryList());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BuildGroup)) {
            return false;
        }
        BuildGroup other = (BuildGroup)obj;
        if (other.getIdentifier() == null ^ this.getIdentifier() == null) {
            return false;
        }
        if (other.getIdentifier() != null && !other.getIdentifier().equals(this.getIdentifier())) {
            return false;
        }
        if (other.getDependsOn() == null ^ this.getDependsOn() == null) {
            return false;
        }
        if (other.getDependsOn() != null && !other.getDependsOn().equals(this.getDependsOn())) {
            return false;
        }
        if (other.getIgnoreFailure() == null ^ this.getIgnoreFailure() == null) {
            return false;
        }
        if (other.getIgnoreFailure() != null && !other.getIgnoreFailure().equals(this.getIgnoreFailure())) {
            return false;
        }
        if (other.getCurrentBuildSummary() == null ^ this.getCurrentBuildSummary() == null) {
            return false;
        }
        if (other.getCurrentBuildSummary() != null && !other.getCurrentBuildSummary().equals(this.getCurrentBuildSummary())) {
            return false;
        }
        if (other.getPriorBuildSummaryList() == null ^ this.getPriorBuildSummaryList() == null) {
            return false;
        }
        return other.getPriorBuildSummaryList() == null || other.getPriorBuildSummaryList().equals(this.getPriorBuildSummaryList());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getIdentifier() == null ? 0 : this.getIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getDependsOn() == null ? 0 : this.getDependsOn().hashCode());
        hashCode = 31 * hashCode + (this.getIgnoreFailure() == null ? 0 : this.getIgnoreFailure().hashCode());
        hashCode = 31 * hashCode + (this.getCurrentBuildSummary() == null ? 0 : this.getCurrentBuildSummary().hashCode());
        hashCode = 31 * hashCode + (this.getPriorBuildSummaryList() == null ? 0 : this.getPriorBuildSummaryList().hashCode());
        return hashCode;
    }

    public BuildGroup clone() {
        try {
            return (BuildGroup)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BuildGroupMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

