/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codebuild.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.codebuild.model.ListBuildsForProjectRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class ListBuildsForProjectRequestMarshaller
implements Marshaller<Request<ListBuildsForProjectRequest>, ListBuildsForProjectRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public ListBuildsForProjectRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<ListBuildsForProjectRequest> marshall(ListBuildsForProjectRequest listBuildsForProjectRequest) {
        if (listBuildsForProjectRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listBuildsForProjectRequest, "AWSCodeBuild");
        request.addHeader("X-Amz-Target", "CodeBuild_20161006.ListBuildsForProject");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (listBuildsForProjectRequest.getProjectName() != null) {
                jsonGenerator.writeFieldName("projectName").writeValue(listBuildsForProjectRequest.getProjectName());
            }
            if (listBuildsForProjectRequest.getSortOrder() != null) {
                jsonGenerator.writeFieldName("sortOrder").writeValue(listBuildsForProjectRequest.getSortOrder());
            }
            if (listBuildsForProjectRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("nextToken").writeValue(listBuildsForProjectRequest.getNextToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

