/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codebuild;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.codebuild.AWSCodeBuildAsync;
import com.amazonaws.services.codebuild.AWSCodeBuildAsyncClientBuilder;
import com.amazonaws.services.codebuild.AWSCodeBuildClient;
import com.amazonaws.services.codebuild.model.BatchDeleteBuildsRequest;
import com.amazonaws.services.codebuild.model.BatchDeleteBuildsResult;
import com.amazonaws.services.codebuild.model.BatchGetBuildsRequest;
import com.amazonaws.services.codebuild.model.BatchGetBuildsResult;
import com.amazonaws.services.codebuild.model.BatchGetProjectsRequest;
import com.amazonaws.services.codebuild.model.BatchGetProjectsResult;
import com.amazonaws.services.codebuild.model.CreateProjectRequest;
import com.amazonaws.services.codebuild.model.CreateProjectResult;
import com.amazonaws.services.codebuild.model.CreateWebhookRequest;
import com.amazonaws.services.codebuild.model.CreateWebhookResult;
import com.amazonaws.services.codebuild.model.DeleteProjectRequest;
import com.amazonaws.services.codebuild.model.DeleteProjectResult;
import com.amazonaws.services.codebuild.model.DeleteWebhookRequest;
import com.amazonaws.services.codebuild.model.DeleteWebhookResult;
import com.amazonaws.services.codebuild.model.InvalidateProjectCacheRequest;
import com.amazonaws.services.codebuild.model.InvalidateProjectCacheResult;
import com.amazonaws.services.codebuild.model.ListBuildsForProjectRequest;
import com.amazonaws.services.codebuild.model.ListBuildsForProjectResult;
import com.amazonaws.services.codebuild.model.ListBuildsRequest;
import com.amazonaws.services.codebuild.model.ListBuildsResult;
import com.amazonaws.services.codebuild.model.ListCuratedEnvironmentImagesRequest;
import com.amazonaws.services.codebuild.model.ListCuratedEnvironmentImagesResult;
import com.amazonaws.services.codebuild.model.ListProjectsRequest;
import com.amazonaws.services.codebuild.model.ListProjectsResult;
import com.amazonaws.services.codebuild.model.StartBuildRequest;
import com.amazonaws.services.codebuild.model.StartBuildResult;
import com.amazonaws.services.codebuild.model.StopBuildRequest;
import com.amazonaws.services.codebuild.model.StopBuildResult;
import com.amazonaws.services.codebuild.model.UpdateProjectRequest;
import com.amazonaws.services.codebuild.model.UpdateProjectResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSCodeBuildAsyncClient
extends AWSCodeBuildClient
implements AWSCodeBuildAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    @Deprecated
    public AWSCodeBuildAsyncClient() {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance());
    }

    @Deprecated
    public AWSCodeBuildAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AWSCodeBuildAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AWSCodeBuildAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AWSCodeBuildAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    @Deprecated
    public AWSCodeBuildAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AWSCodeBuildAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AWSCodeBuildAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AWSCodeBuildAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public static AWSCodeBuildAsyncClientBuilder asyncBuilder() {
        return AWSCodeBuildAsyncClientBuilder.standard();
    }

    AWSCodeBuildAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super((AwsSyncClientParams)asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<BatchDeleteBuildsResult> batchDeleteBuildsAsync(BatchDeleteBuildsRequest request) {
        return this.batchDeleteBuildsAsync(request, null);
    }

    @Override
    public Future<BatchDeleteBuildsResult> batchDeleteBuildsAsync(BatchDeleteBuildsRequest request, final AsyncHandler<BatchDeleteBuildsRequest, BatchDeleteBuildsResult> asyncHandler) {
        final BatchDeleteBuildsRequest finalRequest = (BatchDeleteBuildsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchDeleteBuildsResult>(){

            @Override
            public BatchDeleteBuildsResult call() throws Exception {
                BatchDeleteBuildsResult result = null;
                try {
                    result = AWSCodeBuildAsyncClient.this.executeBatchDeleteBuilds(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<BatchGetBuildsResult> batchGetBuildsAsync(BatchGetBuildsRequest request) {
        return this.batchGetBuildsAsync(request, null);
    }

    @Override
    public Future<BatchGetBuildsResult> batchGetBuildsAsync(BatchGetBuildsRequest request, final AsyncHandler<BatchGetBuildsRequest, BatchGetBuildsResult> asyncHandler) {
        final BatchGetBuildsRequest finalRequest = (BatchGetBuildsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchGetBuildsResult>(){

            @Override
            public BatchGetBuildsResult call() throws Exception {
                BatchGetBuildsResult result = null;
                try {
                    result = AWSCodeBuildAsyncClient.this.executeBatchGetBuilds(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<BatchGetProjectsResult> batchGetProjectsAsync(BatchGetProjectsRequest request) {
        return this.batchGetProjectsAsync(request, null);
    }

    @Override
    public Future<BatchGetProjectsResult> batchGetProjectsAsync(BatchGetProjectsRequest request, final AsyncHandler<BatchGetProjectsRequest, BatchGetProjectsResult> asyncHandler) {
        final BatchGetProjectsRequest finalRequest = (BatchGetProjectsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchGetProjectsResult>(){

            @Override
            public BatchGetProjectsResult call() throws Exception {
                BatchGetProjectsResult result = null;
                try {
                    result = AWSCodeBuildAsyncClient.this.executeBatchGetProjects(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateProjectResult> createProjectAsync(CreateProjectRequest request) {
        return this.createProjectAsync(request, null);
    }

    @Override
    public Future<CreateProjectResult> createProjectAsync(CreateProjectRequest request, final AsyncHandler<CreateProjectRequest, CreateProjectResult> asyncHandler) {
        final CreateProjectRequest finalRequest = (CreateProjectRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateProjectResult>(){

            @Override
            public CreateProjectResult call() throws Exception {
                CreateProjectResult result = null;
                try {
                    result = AWSCodeBuildAsyncClient.this.executeCreateProject(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateWebhookResult> createWebhookAsync(CreateWebhookRequest request) {
        return this.createWebhookAsync(request, null);
    }

    @Override
    public Future<CreateWebhookResult> createWebhookAsync(CreateWebhookRequest request, final AsyncHandler<CreateWebhookRequest, CreateWebhookResult> asyncHandler) {
        final CreateWebhookRequest finalRequest = (CreateWebhookRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateWebhookResult>(){

            @Override
            public CreateWebhookResult call() throws Exception {
                CreateWebhookResult result = null;
                try {
                    result = AWSCodeBuildAsyncClient.this.executeCreateWebhook(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteProjectResult> deleteProjectAsync(DeleteProjectRequest request) {
        return this.deleteProjectAsync(request, null);
    }

    @Override
    public Future<DeleteProjectResult> deleteProjectAsync(DeleteProjectRequest request, final AsyncHandler<DeleteProjectRequest, DeleteProjectResult> asyncHandler) {
        final DeleteProjectRequest finalRequest = (DeleteProjectRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteProjectResult>(){

            @Override
            public DeleteProjectResult call() throws Exception {
                DeleteProjectResult result = null;
                try {
                    result = AWSCodeBuildAsyncClient.this.executeDeleteProject(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteWebhookResult> deleteWebhookAsync(DeleteWebhookRequest request) {
        return this.deleteWebhookAsync(request, null);
    }

    @Override
    public Future<DeleteWebhookResult> deleteWebhookAsync(DeleteWebhookRequest request, final AsyncHandler<DeleteWebhookRequest, DeleteWebhookResult> asyncHandler) {
        final DeleteWebhookRequest finalRequest = (DeleteWebhookRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteWebhookResult>(){

            @Override
            public DeleteWebhookResult call() throws Exception {
                DeleteWebhookResult result = null;
                try {
                    result = AWSCodeBuildAsyncClient.this.executeDeleteWebhook(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<InvalidateProjectCacheResult> invalidateProjectCacheAsync(InvalidateProjectCacheRequest request) {
        return this.invalidateProjectCacheAsync(request, null);
    }

    @Override
    public Future<InvalidateProjectCacheResult> invalidateProjectCacheAsync(InvalidateProjectCacheRequest request, final AsyncHandler<InvalidateProjectCacheRequest, InvalidateProjectCacheResult> asyncHandler) {
        final InvalidateProjectCacheRequest finalRequest = (InvalidateProjectCacheRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<InvalidateProjectCacheResult>(){

            @Override
            public InvalidateProjectCacheResult call() throws Exception {
                InvalidateProjectCacheResult result = null;
                try {
                    result = AWSCodeBuildAsyncClient.this.executeInvalidateProjectCache(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListBuildsResult> listBuildsAsync(ListBuildsRequest request) {
        return this.listBuildsAsync(request, null);
    }

    @Override
    public Future<ListBuildsResult> listBuildsAsync(ListBuildsRequest request, final AsyncHandler<ListBuildsRequest, ListBuildsResult> asyncHandler) {
        final ListBuildsRequest finalRequest = (ListBuildsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListBuildsResult>(){

            @Override
            public ListBuildsResult call() throws Exception {
                ListBuildsResult result = null;
                try {
                    result = AWSCodeBuildAsyncClient.this.executeListBuilds(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListBuildsForProjectResult> listBuildsForProjectAsync(ListBuildsForProjectRequest request) {
        return this.listBuildsForProjectAsync(request, null);
    }

    @Override
    public Future<ListBuildsForProjectResult> listBuildsForProjectAsync(ListBuildsForProjectRequest request, final AsyncHandler<ListBuildsForProjectRequest, ListBuildsForProjectResult> asyncHandler) {
        final ListBuildsForProjectRequest finalRequest = (ListBuildsForProjectRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListBuildsForProjectResult>(){

            @Override
            public ListBuildsForProjectResult call() throws Exception {
                ListBuildsForProjectResult result = null;
                try {
                    result = AWSCodeBuildAsyncClient.this.executeListBuildsForProject(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListCuratedEnvironmentImagesResult> listCuratedEnvironmentImagesAsync(ListCuratedEnvironmentImagesRequest request) {
        return this.listCuratedEnvironmentImagesAsync(request, null);
    }

    @Override
    public Future<ListCuratedEnvironmentImagesResult> listCuratedEnvironmentImagesAsync(ListCuratedEnvironmentImagesRequest request, final AsyncHandler<ListCuratedEnvironmentImagesRequest, ListCuratedEnvironmentImagesResult> asyncHandler) {
        final ListCuratedEnvironmentImagesRequest finalRequest = (ListCuratedEnvironmentImagesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListCuratedEnvironmentImagesResult>(){

            @Override
            public ListCuratedEnvironmentImagesResult call() throws Exception {
                ListCuratedEnvironmentImagesResult result = null;
                try {
                    result = AWSCodeBuildAsyncClient.this.executeListCuratedEnvironmentImages(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListProjectsResult> listProjectsAsync(ListProjectsRequest request) {
        return this.listProjectsAsync(request, null);
    }

    @Override
    public Future<ListProjectsResult> listProjectsAsync(ListProjectsRequest request, final AsyncHandler<ListProjectsRequest, ListProjectsResult> asyncHandler) {
        final ListProjectsRequest finalRequest = (ListProjectsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListProjectsResult>(){

            @Override
            public ListProjectsResult call() throws Exception {
                ListProjectsResult result = null;
                try {
                    result = AWSCodeBuildAsyncClient.this.executeListProjects(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartBuildResult> startBuildAsync(StartBuildRequest request) {
        return this.startBuildAsync(request, null);
    }

    @Override
    public Future<StartBuildResult> startBuildAsync(StartBuildRequest request, final AsyncHandler<StartBuildRequest, StartBuildResult> asyncHandler) {
        final StartBuildRequest finalRequest = (StartBuildRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartBuildResult>(){

            @Override
            public StartBuildResult call() throws Exception {
                StartBuildResult result = null;
                try {
                    result = AWSCodeBuildAsyncClient.this.executeStartBuild(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StopBuildResult> stopBuildAsync(StopBuildRequest request) {
        return this.stopBuildAsync(request, null);
    }

    @Override
    public Future<StopBuildResult> stopBuildAsync(StopBuildRequest request, final AsyncHandler<StopBuildRequest, StopBuildResult> asyncHandler) {
        final StopBuildRequest finalRequest = (StopBuildRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StopBuildResult>(){

            @Override
            public StopBuildResult call() throws Exception {
                StopBuildResult result = null;
                try {
                    result = AWSCodeBuildAsyncClient.this.executeStopBuild(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateProjectResult> updateProjectAsync(UpdateProjectRequest request) {
        return this.updateProjectAsync(request, null);
    }

    @Override
    public Future<UpdateProjectResult> updateProjectAsync(UpdateProjectRequest request, final AsyncHandler<UpdateProjectRequest, UpdateProjectResult> asyncHandler) {
        final UpdateProjectRequest finalRequest = (UpdateProjectRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateProjectResult>(){

            @Override
            public UpdateProjectResult call() throws Exception {
                UpdateProjectResult result = null;
                try {
                    result = AWSCodeBuildAsyncClient.this.executeUpdateProject(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

