/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codebuild.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.codebuild.model.EnvironmentImage;
import com.amazonaws.services.codebuild.model.LanguageType;
import com.amazonaws.services.codebuild.model.transform.EnvironmentLanguageMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class EnvironmentLanguage
implements Serializable,
Cloneable,
StructuredPojo {
    private String language;
    private List<EnvironmentImage> images;

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getLanguage() {
        return this.language;
    }

    public EnvironmentLanguage withLanguage(String language) {
        this.setLanguage(language);
        return this;
    }

    public void setLanguage(LanguageType language) {
        this.language = language.toString();
    }

    public EnvironmentLanguage withLanguage(LanguageType language) {
        this.setLanguage(language);
        return this;
    }

    public List<EnvironmentImage> getImages() {
        return this.images;
    }

    public void setImages(Collection<EnvironmentImage> images) {
        if (images == null) {
            this.images = null;
            return;
        }
        this.images = new ArrayList<EnvironmentImage>(images);
    }

    public EnvironmentLanguage withImages(EnvironmentImage ... images) {
        if (this.images == null) {
            this.setImages(new ArrayList<EnvironmentImage>(images.length));
        }
        for (EnvironmentImage ele : images) {
            this.images.add(ele);
        }
        return this;
    }

    public EnvironmentLanguage withImages(Collection<EnvironmentImage> images) {
        this.setImages(images);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getLanguage() != null) {
            sb.append("Language: ").append(this.getLanguage()).append(",");
        }
        if (this.getImages() != null) {
            sb.append("Images: ").append(this.getImages());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnvironmentLanguage)) {
            return false;
        }
        EnvironmentLanguage other = (EnvironmentLanguage)obj;
        if (other.getLanguage() == null ^ this.getLanguage() == null) {
            return false;
        }
        if (other.getLanguage() != null && !other.getLanguage().equals(this.getLanguage())) {
            return false;
        }
        if (other.getImages() == null ^ this.getImages() == null) {
            return false;
        }
        return other.getImages() == null || other.getImages().equals(this.getImages());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getLanguage() == null ? 0 : this.getLanguage().hashCode());
        hashCode = 31 * hashCode + (this.getImages() == null ? 0 : this.getImages().hashCode());
        return hashCode;
    }

    public EnvironmentLanguage clone() {
        try {
            return (EnvironmentLanguage)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EnvironmentLanguageMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

