/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codebuild.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.codebuild.model.BuildArtifacts;
import com.amazonaws.services.codebuild.model.BuildPhase;
import com.amazonaws.services.codebuild.model.DebugSession;
import com.amazonaws.services.codebuild.model.ExportedEnvironmentVariable;
import com.amazonaws.services.codebuild.model.LogsLocation;
import com.amazonaws.services.codebuild.model.NetworkInterface;
import com.amazonaws.services.codebuild.model.ProjectCache;
import com.amazonaws.services.codebuild.model.ProjectEnvironment;
import com.amazonaws.services.codebuild.model.ProjectFileSystemLocation;
import com.amazonaws.services.codebuild.model.ProjectSource;
import com.amazonaws.services.codebuild.model.ProjectSourceVersion;
import com.amazonaws.services.codebuild.model.StatusType;
import com.amazonaws.services.codebuild.model.VpcConfig;
import com.amazonaws.services.codebuild.model.transform.BuildMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class Build
implements Serializable,
Cloneable,
StructuredPojo {
    private String id;
    private String arn;
    private Long buildNumber;
    private Date startTime;
    private Date endTime;
    private String currentPhase;
    private String buildStatus;
    private String sourceVersion;
    private String resolvedSourceVersion;
    private String projectName;
    private List<BuildPhase> phases;
    private ProjectSource source;
    private List<ProjectSource> secondarySources;
    private List<ProjectSourceVersion> secondarySourceVersions;
    private BuildArtifacts artifacts;
    private List<BuildArtifacts> secondaryArtifacts;
    private ProjectCache cache;
    private ProjectEnvironment environment;
    private String serviceRole;
    private LogsLocation logs;
    private Integer timeoutInMinutes;
    private Integer queuedTimeoutInMinutes;
    private Boolean buildComplete;
    private String initiator;
    private VpcConfig vpcConfig;
    private NetworkInterface networkInterface;
    private String encryptionKey;
    private List<ExportedEnvironmentVariable> exportedEnvironmentVariables;
    private List<String> reportArns;
    private List<ProjectFileSystemLocation> fileSystemLocations;
    private DebugSession debugSession;
    private String buildBatchArn;

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public Build withId(String id) {
        this.setId(id);
        return this;
    }

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public Build withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public void setBuildNumber(Long buildNumber) {
        this.buildNumber = buildNumber;
    }

    public Long getBuildNumber() {
        return this.buildNumber;
    }

    public Build withBuildNumber(Long buildNumber) {
        this.setBuildNumber(buildNumber);
        return this;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Build withStartTime(Date startTime) {
        this.setStartTime(startTime);
        return this;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public Build withEndTime(Date endTime) {
        this.setEndTime(endTime);
        return this;
    }

    public void setCurrentPhase(String currentPhase) {
        this.currentPhase = currentPhase;
    }

    public String getCurrentPhase() {
        return this.currentPhase;
    }

    public Build withCurrentPhase(String currentPhase) {
        this.setCurrentPhase(currentPhase);
        return this;
    }

    public void setBuildStatus(String buildStatus) {
        this.buildStatus = buildStatus;
    }

    public String getBuildStatus() {
        return this.buildStatus;
    }

    public Build withBuildStatus(String buildStatus) {
        this.setBuildStatus(buildStatus);
        return this;
    }

    public void setBuildStatus(StatusType buildStatus) {
        this.withBuildStatus(buildStatus);
    }

    public Build withBuildStatus(StatusType buildStatus) {
        this.buildStatus = buildStatus.toString();
        return this;
    }

    public void setSourceVersion(String sourceVersion) {
        this.sourceVersion = sourceVersion;
    }

    public String getSourceVersion() {
        return this.sourceVersion;
    }

    public Build withSourceVersion(String sourceVersion) {
        this.setSourceVersion(sourceVersion);
        return this;
    }

    public void setResolvedSourceVersion(String resolvedSourceVersion) {
        this.resolvedSourceVersion = resolvedSourceVersion;
    }

    public String getResolvedSourceVersion() {
        return this.resolvedSourceVersion;
    }

    public Build withResolvedSourceVersion(String resolvedSourceVersion) {
        this.setResolvedSourceVersion(resolvedSourceVersion);
        return this;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public Build withProjectName(String projectName) {
        this.setProjectName(projectName);
        return this;
    }

    public List<BuildPhase> getPhases() {
        return this.phases;
    }

    public void setPhases(Collection<BuildPhase> phases) {
        if (phases == null) {
            this.phases = null;
            return;
        }
        this.phases = new ArrayList<BuildPhase>(phases);
    }

    public Build withPhases(BuildPhase ... phases) {
        if (this.phases == null) {
            this.setPhases(new ArrayList<BuildPhase>(phases.length));
        }
        for (BuildPhase ele : phases) {
            this.phases.add(ele);
        }
        return this;
    }

    public Build withPhases(Collection<BuildPhase> phases) {
        this.setPhases(phases);
        return this;
    }

    public void setSource(ProjectSource source) {
        this.source = source;
    }

    public ProjectSource getSource() {
        return this.source;
    }

    public Build withSource(ProjectSource source) {
        this.setSource(source);
        return this;
    }

    public List<ProjectSource> getSecondarySources() {
        return this.secondarySources;
    }

    public void setSecondarySources(Collection<ProjectSource> secondarySources) {
        if (secondarySources == null) {
            this.secondarySources = null;
            return;
        }
        this.secondarySources = new ArrayList<ProjectSource>(secondarySources);
    }

    public Build withSecondarySources(ProjectSource ... secondarySources) {
        if (this.secondarySources == null) {
            this.setSecondarySources(new ArrayList<ProjectSource>(secondarySources.length));
        }
        for (ProjectSource ele : secondarySources) {
            this.secondarySources.add(ele);
        }
        return this;
    }

    public Build withSecondarySources(Collection<ProjectSource> secondarySources) {
        this.setSecondarySources(secondarySources);
        return this;
    }

    public List<ProjectSourceVersion> getSecondarySourceVersions() {
        return this.secondarySourceVersions;
    }

    public void setSecondarySourceVersions(Collection<ProjectSourceVersion> secondarySourceVersions) {
        if (secondarySourceVersions == null) {
            this.secondarySourceVersions = null;
            return;
        }
        this.secondarySourceVersions = new ArrayList<ProjectSourceVersion>(secondarySourceVersions);
    }

    public Build withSecondarySourceVersions(ProjectSourceVersion ... secondarySourceVersions) {
        if (this.secondarySourceVersions == null) {
            this.setSecondarySourceVersions(new ArrayList<ProjectSourceVersion>(secondarySourceVersions.length));
        }
        for (ProjectSourceVersion ele : secondarySourceVersions) {
            this.secondarySourceVersions.add(ele);
        }
        return this;
    }

    public Build withSecondarySourceVersions(Collection<ProjectSourceVersion> secondarySourceVersions) {
        this.setSecondarySourceVersions(secondarySourceVersions);
        return this;
    }

    public void setArtifacts(BuildArtifacts artifacts) {
        this.artifacts = artifacts;
    }

    public BuildArtifacts getArtifacts() {
        return this.artifacts;
    }

    public Build withArtifacts(BuildArtifacts artifacts) {
        this.setArtifacts(artifacts);
        return this;
    }

    public List<BuildArtifacts> getSecondaryArtifacts() {
        return this.secondaryArtifacts;
    }

    public void setSecondaryArtifacts(Collection<BuildArtifacts> secondaryArtifacts) {
        if (secondaryArtifacts == null) {
            this.secondaryArtifacts = null;
            return;
        }
        this.secondaryArtifacts = new ArrayList<BuildArtifacts>(secondaryArtifacts);
    }

    public Build withSecondaryArtifacts(BuildArtifacts ... secondaryArtifacts) {
        if (this.secondaryArtifacts == null) {
            this.setSecondaryArtifacts(new ArrayList<BuildArtifacts>(secondaryArtifacts.length));
        }
        for (BuildArtifacts ele : secondaryArtifacts) {
            this.secondaryArtifacts.add(ele);
        }
        return this;
    }

    public Build withSecondaryArtifacts(Collection<BuildArtifacts> secondaryArtifacts) {
        this.setSecondaryArtifacts(secondaryArtifacts);
        return this;
    }

    public void setCache(ProjectCache cache) {
        this.cache = cache;
    }

    public ProjectCache getCache() {
        return this.cache;
    }

    public Build withCache(ProjectCache cache) {
        this.setCache(cache);
        return this;
    }

    public void setEnvironment(ProjectEnvironment environment) {
        this.environment = environment;
    }

    public ProjectEnvironment getEnvironment() {
        return this.environment;
    }

    public Build withEnvironment(ProjectEnvironment environment) {
        this.setEnvironment(environment);
        return this;
    }

    public void setServiceRole(String serviceRole) {
        this.serviceRole = serviceRole;
    }

    public String getServiceRole() {
        return this.serviceRole;
    }

    public Build withServiceRole(String serviceRole) {
        this.setServiceRole(serviceRole);
        return this;
    }

    public void setLogs(LogsLocation logs) {
        this.logs = logs;
    }

    public LogsLocation getLogs() {
        return this.logs;
    }

    public Build withLogs(LogsLocation logs) {
        this.setLogs(logs);
        return this;
    }

    public void setTimeoutInMinutes(Integer timeoutInMinutes) {
        this.timeoutInMinutes = timeoutInMinutes;
    }

    public Integer getTimeoutInMinutes() {
        return this.timeoutInMinutes;
    }

    public Build withTimeoutInMinutes(Integer timeoutInMinutes) {
        this.setTimeoutInMinutes(timeoutInMinutes);
        return this;
    }

    public void setQueuedTimeoutInMinutes(Integer queuedTimeoutInMinutes) {
        this.queuedTimeoutInMinutes = queuedTimeoutInMinutes;
    }

    public Integer getQueuedTimeoutInMinutes() {
        return this.queuedTimeoutInMinutes;
    }

    public Build withQueuedTimeoutInMinutes(Integer queuedTimeoutInMinutes) {
        this.setQueuedTimeoutInMinutes(queuedTimeoutInMinutes);
        return this;
    }

    public void setBuildComplete(Boolean buildComplete) {
        this.buildComplete = buildComplete;
    }

    public Boolean getBuildComplete() {
        return this.buildComplete;
    }

    public Build withBuildComplete(Boolean buildComplete) {
        this.setBuildComplete(buildComplete);
        return this;
    }

    public Boolean isBuildComplete() {
        return this.buildComplete;
    }

    public void setInitiator(String initiator) {
        this.initiator = initiator;
    }

    public String getInitiator() {
        return this.initiator;
    }

    public Build withInitiator(String initiator) {
        this.setInitiator(initiator);
        return this;
    }

    public void setVpcConfig(VpcConfig vpcConfig) {
        this.vpcConfig = vpcConfig;
    }

    public VpcConfig getVpcConfig() {
        return this.vpcConfig;
    }

    public Build withVpcConfig(VpcConfig vpcConfig) {
        this.setVpcConfig(vpcConfig);
        return this;
    }

    public void setNetworkInterface(NetworkInterface networkInterface) {
        this.networkInterface = networkInterface;
    }

    public NetworkInterface getNetworkInterface() {
        return this.networkInterface;
    }

    public Build withNetworkInterface(NetworkInterface networkInterface) {
        this.setNetworkInterface(networkInterface);
        return this;
    }

    public void setEncryptionKey(String encryptionKey) {
        this.encryptionKey = encryptionKey;
    }

    public String getEncryptionKey() {
        return this.encryptionKey;
    }

    public Build withEncryptionKey(String encryptionKey) {
        this.setEncryptionKey(encryptionKey);
        return this;
    }

    public List<ExportedEnvironmentVariable> getExportedEnvironmentVariables() {
        return this.exportedEnvironmentVariables;
    }

    public void setExportedEnvironmentVariables(Collection<ExportedEnvironmentVariable> exportedEnvironmentVariables) {
        if (exportedEnvironmentVariables == null) {
            this.exportedEnvironmentVariables = null;
            return;
        }
        this.exportedEnvironmentVariables = new ArrayList<ExportedEnvironmentVariable>(exportedEnvironmentVariables);
    }

    public Build withExportedEnvironmentVariables(ExportedEnvironmentVariable ... exportedEnvironmentVariables) {
        if (this.exportedEnvironmentVariables == null) {
            this.setExportedEnvironmentVariables(new ArrayList<ExportedEnvironmentVariable>(exportedEnvironmentVariables.length));
        }
        for (ExportedEnvironmentVariable ele : exportedEnvironmentVariables) {
            this.exportedEnvironmentVariables.add(ele);
        }
        return this;
    }

    public Build withExportedEnvironmentVariables(Collection<ExportedEnvironmentVariable> exportedEnvironmentVariables) {
        this.setExportedEnvironmentVariables(exportedEnvironmentVariables);
        return this;
    }

    public List<String> getReportArns() {
        return this.reportArns;
    }

    public void setReportArns(Collection<String> reportArns) {
        if (reportArns == null) {
            this.reportArns = null;
            return;
        }
        this.reportArns = new ArrayList<String>(reportArns);
    }

    public Build withReportArns(String ... reportArns) {
        if (this.reportArns == null) {
            this.setReportArns(new ArrayList<String>(reportArns.length));
        }
        for (String ele : reportArns) {
            this.reportArns.add(ele);
        }
        return this;
    }

    public Build withReportArns(Collection<String> reportArns) {
        this.setReportArns(reportArns);
        return this;
    }

    public List<ProjectFileSystemLocation> getFileSystemLocations() {
        return this.fileSystemLocations;
    }

    public void setFileSystemLocations(Collection<ProjectFileSystemLocation> fileSystemLocations) {
        if (fileSystemLocations == null) {
            this.fileSystemLocations = null;
            return;
        }
        this.fileSystemLocations = new ArrayList<ProjectFileSystemLocation>(fileSystemLocations);
    }

    public Build withFileSystemLocations(ProjectFileSystemLocation ... fileSystemLocations) {
        if (this.fileSystemLocations == null) {
            this.setFileSystemLocations(new ArrayList<ProjectFileSystemLocation>(fileSystemLocations.length));
        }
        for (ProjectFileSystemLocation ele : fileSystemLocations) {
            this.fileSystemLocations.add(ele);
        }
        return this;
    }

    public Build withFileSystemLocations(Collection<ProjectFileSystemLocation> fileSystemLocations) {
        this.setFileSystemLocations(fileSystemLocations);
        return this;
    }

    public void setDebugSession(DebugSession debugSession) {
        this.debugSession = debugSession;
    }

    public DebugSession getDebugSession() {
        return this.debugSession;
    }

    public Build withDebugSession(DebugSession debugSession) {
        this.setDebugSession(debugSession);
        return this;
    }

    public void setBuildBatchArn(String buildBatchArn) {
        this.buildBatchArn = buildBatchArn;
    }

    public String getBuildBatchArn() {
        return this.buildBatchArn;
    }

    public Build withBuildBatchArn(String buildBatchArn) {
        this.setBuildBatchArn(buildBatchArn);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getId() != null) {
            sb.append("Id: ").append(this.getId()).append(",");
        }
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getBuildNumber() != null) {
            sb.append("BuildNumber: ").append(this.getBuildNumber()).append(",");
        }
        if (this.getStartTime() != null) {
            sb.append("StartTime: ").append(this.getStartTime()).append(",");
        }
        if (this.getEndTime() != null) {
            sb.append("EndTime: ").append(this.getEndTime()).append(",");
        }
        if (this.getCurrentPhase() != null) {
            sb.append("CurrentPhase: ").append(this.getCurrentPhase()).append(",");
        }
        if (this.getBuildStatus() != null) {
            sb.append("BuildStatus: ").append(this.getBuildStatus()).append(",");
        }
        if (this.getSourceVersion() != null) {
            sb.append("SourceVersion: ").append(this.getSourceVersion()).append(",");
        }
        if (this.getResolvedSourceVersion() != null) {
            sb.append("ResolvedSourceVersion: ").append(this.getResolvedSourceVersion()).append(",");
        }
        if (this.getProjectName() != null) {
            sb.append("ProjectName: ").append(this.getProjectName()).append(",");
        }
        if (this.getPhases() != null) {
            sb.append("Phases: ").append(this.getPhases()).append(",");
        }
        if (this.getSource() != null) {
            sb.append("Source: ").append(this.getSource()).append(",");
        }
        if (this.getSecondarySources() != null) {
            sb.append("SecondarySources: ").append(this.getSecondarySources()).append(",");
        }
        if (this.getSecondarySourceVersions() != null) {
            sb.append("SecondarySourceVersions: ").append(this.getSecondarySourceVersions()).append(",");
        }
        if (this.getArtifacts() != null) {
            sb.append("Artifacts: ").append(this.getArtifacts()).append(",");
        }
        if (this.getSecondaryArtifacts() != null) {
            sb.append("SecondaryArtifacts: ").append(this.getSecondaryArtifacts()).append(",");
        }
        if (this.getCache() != null) {
            sb.append("Cache: ").append(this.getCache()).append(",");
        }
        if (this.getEnvironment() != null) {
            sb.append("Environment: ").append(this.getEnvironment()).append(",");
        }
        if (this.getServiceRole() != null) {
            sb.append("ServiceRole: ").append(this.getServiceRole()).append(",");
        }
        if (this.getLogs() != null) {
            sb.append("Logs: ").append(this.getLogs()).append(",");
        }
        if (this.getTimeoutInMinutes() != null) {
            sb.append("TimeoutInMinutes: ").append(this.getTimeoutInMinutes()).append(",");
        }
        if (this.getQueuedTimeoutInMinutes() != null) {
            sb.append("QueuedTimeoutInMinutes: ").append(this.getQueuedTimeoutInMinutes()).append(",");
        }
        if (this.getBuildComplete() != null) {
            sb.append("BuildComplete: ").append(this.getBuildComplete()).append(",");
        }
        if (this.getInitiator() != null) {
            sb.append("Initiator: ").append(this.getInitiator()).append(",");
        }
        if (this.getVpcConfig() != null) {
            sb.append("VpcConfig: ").append(this.getVpcConfig()).append(",");
        }
        if (this.getNetworkInterface() != null) {
            sb.append("NetworkInterface: ").append(this.getNetworkInterface()).append(",");
        }
        if (this.getEncryptionKey() != null) {
            sb.append("EncryptionKey: ").append(this.getEncryptionKey()).append(",");
        }
        if (this.getExportedEnvironmentVariables() != null) {
            sb.append("ExportedEnvironmentVariables: ").append(this.getExportedEnvironmentVariables()).append(",");
        }
        if (this.getReportArns() != null) {
            sb.append("ReportArns: ").append(this.getReportArns()).append(",");
        }
        if (this.getFileSystemLocations() != null) {
            sb.append("FileSystemLocations: ").append(this.getFileSystemLocations()).append(",");
        }
        if (this.getDebugSession() != null) {
            sb.append("DebugSession: ").append(this.getDebugSession()).append(",");
        }
        if (this.getBuildBatchArn() != null) {
            sb.append("BuildBatchArn: ").append(this.getBuildBatchArn());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Build)) {
            return false;
        }
        Build other = (Build)obj;
        if (other.getId() == null ^ this.getId() == null) {
            return false;
        }
        if (other.getId() != null && !other.getId().equals(this.getId())) {
            return false;
        }
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getBuildNumber() == null ^ this.getBuildNumber() == null) {
            return false;
        }
        if (other.getBuildNumber() != null && !other.getBuildNumber().equals(this.getBuildNumber())) {
            return false;
        }
        if (other.getStartTime() == null ^ this.getStartTime() == null) {
            return false;
        }
        if (other.getStartTime() != null && !other.getStartTime().equals(this.getStartTime())) {
            return false;
        }
        if (other.getEndTime() == null ^ this.getEndTime() == null) {
            return false;
        }
        if (other.getEndTime() != null && !other.getEndTime().equals(this.getEndTime())) {
            return false;
        }
        if (other.getCurrentPhase() == null ^ this.getCurrentPhase() == null) {
            return false;
        }
        if (other.getCurrentPhase() != null && !other.getCurrentPhase().equals(this.getCurrentPhase())) {
            return false;
        }
        if (other.getBuildStatus() == null ^ this.getBuildStatus() == null) {
            return false;
        }
        if (other.getBuildStatus() != null && !other.getBuildStatus().equals(this.getBuildStatus())) {
            return false;
        }
        if (other.getSourceVersion() == null ^ this.getSourceVersion() == null) {
            return false;
        }
        if (other.getSourceVersion() != null && !other.getSourceVersion().equals(this.getSourceVersion())) {
            return false;
        }
        if (other.getResolvedSourceVersion() == null ^ this.getResolvedSourceVersion() == null) {
            return false;
        }
        if (other.getResolvedSourceVersion() != null && !other.getResolvedSourceVersion().equals(this.getResolvedSourceVersion())) {
            return false;
        }
        if (other.getProjectName() == null ^ this.getProjectName() == null) {
            return false;
        }
        if (other.getProjectName() != null && !other.getProjectName().equals(this.getProjectName())) {
            return false;
        }
        if (other.getPhases() == null ^ this.getPhases() == null) {
            return false;
        }
        if (other.getPhases() != null && !other.getPhases().equals(this.getPhases())) {
            return false;
        }
        if (other.getSource() == null ^ this.getSource() == null) {
            return false;
        }
        if (other.getSource() != null && !other.getSource().equals(this.getSource())) {
            return false;
        }
        if (other.getSecondarySources() == null ^ this.getSecondarySources() == null) {
            return false;
        }
        if (other.getSecondarySources() != null && !other.getSecondarySources().equals(this.getSecondarySources())) {
            return false;
        }
        if (other.getSecondarySourceVersions() == null ^ this.getSecondarySourceVersions() == null) {
            return false;
        }
        if (other.getSecondarySourceVersions() != null && !other.getSecondarySourceVersions().equals(this.getSecondarySourceVersions())) {
            return false;
        }
        if (other.getArtifacts() == null ^ this.getArtifacts() == null) {
            return false;
        }
        if (other.getArtifacts() != null && !other.getArtifacts().equals(this.getArtifacts())) {
            return false;
        }
        if (other.getSecondaryArtifacts() == null ^ this.getSecondaryArtifacts() == null) {
            return false;
        }
        if (other.getSecondaryArtifacts() != null && !other.getSecondaryArtifacts().equals(this.getSecondaryArtifacts())) {
            return false;
        }
        if (other.getCache() == null ^ this.getCache() == null) {
            return false;
        }
        if (other.getCache() != null && !other.getCache().equals(this.getCache())) {
            return false;
        }
        if (other.getEnvironment() == null ^ this.getEnvironment() == null) {
            return false;
        }
        if (other.getEnvironment() != null && !other.getEnvironment().equals(this.getEnvironment())) {
            return false;
        }
        if (other.getServiceRole() == null ^ this.getServiceRole() == null) {
            return false;
        }
        if (other.getServiceRole() != null && !other.getServiceRole().equals(this.getServiceRole())) {
            return false;
        }
        if (other.getLogs() == null ^ this.getLogs() == null) {
            return false;
        }
        if (other.getLogs() != null && !other.getLogs().equals(this.getLogs())) {
            return false;
        }
        if (other.getTimeoutInMinutes() == null ^ this.getTimeoutInMinutes() == null) {
            return false;
        }
        if (other.getTimeoutInMinutes() != null && !other.getTimeoutInMinutes().equals(this.getTimeoutInMinutes())) {
            return false;
        }
        if (other.getQueuedTimeoutInMinutes() == null ^ this.getQueuedTimeoutInMinutes() == null) {
            return false;
        }
        if (other.getQueuedTimeoutInMinutes() != null && !other.getQueuedTimeoutInMinutes().equals(this.getQueuedTimeoutInMinutes())) {
            return false;
        }
        if (other.getBuildComplete() == null ^ this.getBuildComplete() == null) {
            return false;
        }
        if (other.getBuildComplete() != null && !other.getBuildComplete().equals(this.getBuildComplete())) {
            return false;
        }
        if (other.getInitiator() == null ^ this.getInitiator() == null) {
            return false;
        }
        if (other.getInitiator() != null && !other.getInitiator().equals(this.getInitiator())) {
            return false;
        }
        if (other.getVpcConfig() == null ^ this.getVpcConfig() == null) {
            return false;
        }
        if (other.getVpcConfig() != null && !other.getVpcConfig().equals(this.getVpcConfig())) {
            return false;
        }
        if (other.getNetworkInterface() == null ^ this.getNetworkInterface() == null) {
            return false;
        }
        if (other.getNetworkInterface() != null && !other.getNetworkInterface().equals(this.getNetworkInterface())) {
            return false;
        }
        if (other.getEncryptionKey() == null ^ this.getEncryptionKey() == null) {
            return false;
        }
        if (other.getEncryptionKey() != null && !other.getEncryptionKey().equals(this.getEncryptionKey())) {
            return false;
        }
        if (other.getExportedEnvironmentVariables() == null ^ this.getExportedEnvironmentVariables() == null) {
            return false;
        }
        if (other.getExportedEnvironmentVariables() != null && !other.getExportedEnvironmentVariables().equals(this.getExportedEnvironmentVariables())) {
            return false;
        }
        if (other.getReportArns() == null ^ this.getReportArns() == null) {
            return false;
        }
        if (other.getReportArns() != null && !other.getReportArns().equals(this.getReportArns())) {
            return false;
        }
        if (other.getFileSystemLocations() == null ^ this.getFileSystemLocations() == null) {
            return false;
        }
        if (other.getFileSystemLocations() != null && !other.getFileSystemLocations().equals(this.getFileSystemLocations())) {
            return false;
        }
        if (other.getDebugSession() == null ^ this.getDebugSession() == null) {
            return false;
        }
        if (other.getDebugSession() != null && !other.getDebugSession().equals(this.getDebugSession())) {
            return false;
        }
        if (other.getBuildBatchArn() == null ^ this.getBuildBatchArn() == null) {
            return false;
        }
        return other.getBuildBatchArn() == null || other.getBuildBatchArn().equals(this.getBuildBatchArn());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getId() == null ? 0 : this.getId().hashCode());
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getBuildNumber() == null ? 0 : this.getBuildNumber().hashCode());
        hashCode = 31 * hashCode + (this.getStartTime() == null ? 0 : this.getStartTime().hashCode());
        hashCode = 31 * hashCode + (this.getEndTime() == null ? 0 : this.getEndTime().hashCode());
        hashCode = 31 * hashCode + (this.getCurrentPhase() == null ? 0 : this.getCurrentPhase().hashCode());
        hashCode = 31 * hashCode + (this.getBuildStatus() == null ? 0 : this.getBuildStatus().hashCode());
        hashCode = 31 * hashCode + (this.getSourceVersion() == null ? 0 : this.getSourceVersion().hashCode());
        hashCode = 31 * hashCode + (this.getResolvedSourceVersion() == null ? 0 : this.getResolvedSourceVersion().hashCode());
        hashCode = 31 * hashCode + (this.getProjectName() == null ? 0 : this.getProjectName().hashCode());
        hashCode = 31 * hashCode + (this.getPhases() == null ? 0 : this.getPhases().hashCode());
        hashCode = 31 * hashCode + (this.getSource() == null ? 0 : this.getSource().hashCode());
        hashCode = 31 * hashCode + (this.getSecondarySources() == null ? 0 : this.getSecondarySources().hashCode());
        hashCode = 31 * hashCode + (this.getSecondarySourceVersions() == null ? 0 : this.getSecondarySourceVersions().hashCode());
        hashCode = 31 * hashCode + (this.getArtifacts() == null ? 0 : this.getArtifacts().hashCode());
        hashCode = 31 * hashCode + (this.getSecondaryArtifacts() == null ? 0 : this.getSecondaryArtifacts().hashCode());
        hashCode = 31 * hashCode + (this.getCache() == null ? 0 : this.getCache().hashCode());
        hashCode = 31 * hashCode + (this.getEnvironment() == null ? 0 : this.getEnvironment().hashCode());
        hashCode = 31 * hashCode + (this.getServiceRole() == null ? 0 : this.getServiceRole().hashCode());
        hashCode = 31 * hashCode + (this.getLogs() == null ? 0 : this.getLogs().hashCode());
        hashCode = 31 * hashCode + (this.getTimeoutInMinutes() == null ? 0 : this.getTimeoutInMinutes().hashCode());
        hashCode = 31 * hashCode + (this.getQueuedTimeoutInMinutes() == null ? 0 : this.getQueuedTimeoutInMinutes().hashCode());
        hashCode = 31 * hashCode + (this.getBuildComplete() == null ? 0 : this.getBuildComplete().hashCode());
        hashCode = 31 * hashCode + (this.getInitiator() == null ? 0 : this.getInitiator().hashCode());
        hashCode = 31 * hashCode + (this.getVpcConfig() == null ? 0 : this.getVpcConfig().hashCode());
        hashCode = 31 * hashCode + (this.getNetworkInterface() == null ? 0 : this.getNetworkInterface().hashCode());
        hashCode = 31 * hashCode + (this.getEncryptionKey() == null ? 0 : this.getEncryptionKey().hashCode());
        hashCode = 31 * hashCode + (this.getExportedEnvironmentVariables() == null ? 0 : this.getExportedEnvironmentVariables().hashCode());
        hashCode = 31 * hashCode + (this.getReportArns() == null ? 0 : this.getReportArns().hashCode());
        hashCode = 31 * hashCode + (this.getFileSystemLocations() == null ? 0 : this.getFileSystemLocations().hashCode());
        hashCode = 31 * hashCode + (this.getDebugSession() == null ? 0 : this.getDebugSession().hashCode());
        hashCode = 31 * hashCode + (this.getBuildBatchArn() == null ? 0 : this.getBuildBatchArn().hashCode());
        return hashCode;
    }

    public Build clone() {
        try {
            return (Build)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BuildMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

