/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codeartifact.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.codeartifact.model.PackageFormat;
import com.amazonaws.services.codeartifact.model.PackageOriginConfiguration;
import com.amazonaws.services.codeartifact.model.transform.PackageDescriptionMarshaller;
import java.io.Serializable;

public class PackageDescription
implements Serializable,
Cloneable,
StructuredPojo {
    private String format;
    private String namespace;
    private String name;
    private PackageOriginConfiguration originConfiguration;

    public void setFormat(String format) {
        this.format = format;
    }

    public String getFormat() {
        return this.format;
    }

    public PackageDescription withFormat(String format) {
        this.setFormat(format);
        return this;
    }

    public PackageDescription withFormat(PackageFormat format) {
        this.format = format.toString();
        return this;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public PackageDescription withNamespace(String namespace) {
        this.setNamespace(namespace);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public PackageDescription withName(String name) {
        this.setName(name);
        return this;
    }

    public void setOriginConfiguration(PackageOriginConfiguration originConfiguration) {
        this.originConfiguration = originConfiguration;
    }

    public PackageOriginConfiguration getOriginConfiguration() {
        return this.originConfiguration;
    }

    public PackageDescription withOriginConfiguration(PackageOriginConfiguration originConfiguration) {
        this.setOriginConfiguration(originConfiguration);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFormat() != null) {
            sb.append("Format: ").append(this.getFormat()).append(",");
        }
        if (this.getNamespace() != null) {
            sb.append("Namespace: ").append(this.getNamespace()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getOriginConfiguration() != null) {
            sb.append("OriginConfiguration: ").append(this.getOriginConfiguration());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PackageDescription)) {
            return false;
        }
        PackageDescription other = (PackageDescription)obj;
        if (other.getFormat() == null ^ this.getFormat() == null) {
            return false;
        }
        if (other.getFormat() != null && !other.getFormat().equals(this.getFormat())) {
            return false;
        }
        if (other.getNamespace() == null ^ this.getNamespace() == null) {
            return false;
        }
        if (other.getNamespace() != null && !other.getNamespace().equals(this.getNamespace())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getOriginConfiguration() == null ^ this.getOriginConfiguration() == null) {
            return false;
        }
        return other.getOriginConfiguration() == null || other.getOriginConfiguration().equals(this.getOriginConfiguration());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFormat() == null ? 0 : this.getFormat().hashCode());
        hashCode = 31 * hashCode + (this.getNamespace() == null ? 0 : this.getNamespace().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getOriginConfiguration() == null ? 0 : this.getOriginConfiguration().hashCode());
        return hashCode;
    }

    public PackageDescription clone() {
        try {
            return (PackageDescription)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PackageDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

