/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codeartifact.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.codeartifact.model.LicenseInfo;
import com.amazonaws.services.codeartifact.model.PackageFormat;
import com.amazonaws.services.codeartifact.model.PackageVersionStatus;
import com.amazonaws.services.codeartifact.model.transform.PackageVersionDescriptionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class PackageVersionDescription
implements Serializable,
Cloneable,
StructuredPojo {
    private String format;
    private String namespace;
    private String packageName;
    private String displayName;
    private String version;
    private String summary;
    private String homePage;
    private String sourceCodeRepository;
    private Date publishedTime;
    private List<LicenseInfo> licenses;
    private String revision;
    private String status;

    public void setFormat(String format) {
        this.format = format;
    }

    public String getFormat() {
        return this.format;
    }

    public PackageVersionDescription withFormat(String format) {
        this.setFormat(format);
        return this;
    }

    public PackageVersionDescription withFormat(PackageFormat format) {
        this.format = format.toString();
        return this;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public PackageVersionDescription withNamespace(String namespace) {
        this.setNamespace(namespace);
        return this;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public PackageVersionDescription withPackageName(String packageName) {
        this.setPackageName(packageName);
        return this;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public PackageVersionDescription withDisplayName(String displayName) {
        this.setDisplayName(displayName);
        return this;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public PackageVersionDescription withVersion(String version) {
        this.setVersion(version);
        return this;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public String getSummary() {
        return this.summary;
    }

    public PackageVersionDescription withSummary(String summary) {
        this.setSummary(summary);
        return this;
    }

    public void setHomePage(String homePage) {
        this.homePage = homePage;
    }

    public String getHomePage() {
        return this.homePage;
    }

    public PackageVersionDescription withHomePage(String homePage) {
        this.setHomePage(homePage);
        return this;
    }

    public void setSourceCodeRepository(String sourceCodeRepository) {
        this.sourceCodeRepository = sourceCodeRepository;
    }

    public String getSourceCodeRepository() {
        return this.sourceCodeRepository;
    }

    public PackageVersionDescription withSourceCodeRepository(String sourceCodeRepository) {
        this.setSourceCodeRepository(sourceCodeRepository);
        return this;
    }

    public void setPublishedTime(Date publishedTime) {
        this.publishedTime = publishedTime;
    }

    public Date getPublishedTime() {
        return this.publishedTime;
    }

    public PackageVersionDescription withPublishedTime(Date publishedTime) {
        this.setPublishedTime(publishedTime);
        return this;
    }

    public List<LicenseInfo> getLicenses() {
        return this.licenses;
    }

    public void setLicenses(Collection<LicenseInfo> licenses) {
        if (licenses == null) {
            this.licenses = null;
            return;
        }
        this.licenses = new ArrayList<LicenseInfo>(licenses);
    }

    public PackageVersionDescription withLicenses(LicenseInfo ... licenses) {
        if (this.licenses == null) {
            this.setLicenses(new ArrayList<LicenseInfo>(licenses.length));
        }
        for (LicenseInfo ele : licenses) {
            this.licenses.add(ele);
        }
        return this;
    }

    public PackageVersionDescription withLicenses(Collection<LicenseInfo> licenses) {
        this.setLicenses(licenses);
        return this;
    }

    public void setRevision(String revision) {
        this.revision = revision;
    }

    public String getRevision() {
        return this.revision;
    }

    public PackageVersionDescription withRevision(String revision) {
        this.setRevision(revision);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public PackageVersionDescription withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public PackageVersionDescription withStatus(PackageVersionStatus status) {
        this.status = status.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFormat() != null) {
            sb.append("Format: ").append(this.getFormat()).append(",");
        }
        if (this.getNamespace() != null) {
            sb.append("Namespace: ").append(this.getNamespace()).append(",");
        }
        if (this.getPackageName() != null) {
            sb.append("PackageName: ").append(this.getPackageName()).append(",");
        }
        if (this.getDisplayName() != null) {
            sb.append("DisplayName: ").append(this.getDisplayName()).append(",");
        }
        if (this.getVersion() != null) {
            sb.append("Version: ").append(this.getVersion()).append(",");
        }
        if (this.getSummary() != null) {
            sb.append("Summary: ").append(this.getSummary()).append(",");
        }
        if (this.getHomePage() != null) {
            sb.append("HomePage: ").append(this.getHomePage()).append(",");
        }
        if (this.getSourceCodeRepository() != null) {
            sb.append("SourceCodeRepository: ").append(this.getSourceCodeRepository()).append(",");
        }
        if (this.getPublishedTime() != null) {
            sb.append("PublishedTime: ").append(this.getPublishedTime()).append(",");
        }
        if (this.getLicenses() != null) {
            sb.append("Licenses: ").append(this.getLicenses()).append(",");
        }
        if (this.getRevision() != null) {
            sb.append("Revision: ").append(this.getRevision()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PackageVersionDescription)) {
            return false;
        }
        PackageVersionDescription other = (PackageVersionDescription)obj;
        if (other.getFormat() == null ^ this.getFormat() == null) {
            return false;
        }
        if (other.getFormat() != null && !other.getFormat().equals(this.getFormat())) {
            return false;
        }
        if (other.getNamespace() == null ^ this.getNamespace() == null) {
            return false;
        }
        if (other.getNamespace() != null && !other.getNamespace().equals(this.getNamespace())) {
            return false;
        }
        if (other.getPackageName() == null ^ this.getPackageName() == null) {
            return false;
        }
        if (other.getPackageName() != null && !other.getPackageName().equals(this.getPackageName())) {
            return false;
        }
        if (other.getDisplayName() == null ^ this.getDisplayName() == null) {
            return false;
        }
        if (other.getDisplayName() != null && !other.getDisplayName().equals(this.getDisplayName())) {
            return false;
        }
        if (other.getVersion() == null ^ this.getVersion() == null) {
            return false;
        }
        if (other.getVersion() != null && !other.getVersion().equals(this.getVersion())) {
            return false;
        }
        if (other.getSummary() == null ^ this.getSummary() == null) {
            return false;
        }
        if (other.getSummary() != null && !other.getSummary().equals(this.getSummary())) {
            return false;
        }
        if (other.getHomePage() == null ^ this.getHomePage() == null) {
            return false;
        }
        if (other.getHomePage() != null && !other.getHomePage().equals(this.getHomePage())) {
            return false;
        }
        if (other.getSourceCodeRepository() == null ^ this.getSourceCodeRepository() == null) {
            return false;
        }
        if (other.getSourceCodeRepository() != null && !other.getSourceCodeRepository().equals(this.getSourceCodeRepository())) {
            return false;
        }
        if (other.getPublishedTime() == null ^ this.getPublishedTime() == null) {
            return false;
        }
        if (other.getPublishedTime() != null && !other.getPublishedTime().equals(this.getPublishedTime())) {
            return false;
        }
        if (other.getLicenses() == null ^ this.getLicenses() == null) {
            return false;
        }
        if (other.getLicenses() != null && !other.getLicenses().equals(this.getLicenses())) {
            return false;
        }
        if (other.getRevision() == null ^ this.getRevision() == null) {
            return false;
        }
        if (other.getRevision() != null && !other.getRevision().equals(this.getRevision())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        return other.getStatus() == null || other.getStatus().equals(this.getStatus());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFormat() == null ? 0 : this.getFormat().hashCode());
        hashCode = 31 * hashCode + (this.getNamespace() == null ? 0 : this.getNamespace().hashCode());
        hashCode = 31 * hashCode + (this.getPackageName() == null ? 0 : this.getPackageName().hashCode());
        hashCode = 31 * hashCode + (this.getDisplayName() == null ? 0 : this.getDisplayName().hashCode());
        hashCode = 31 * hashCode + (this.getVersion() == null ? 0 : this.getVersion().hashCode());
        hashCode = 31 * hashCode + (this.getSummary() == null ? 0 : this.getSummary().hashCode());
        hashCode = 31 * hashCode + (this.getHomePage() == null ? 0 : this.getHomePage().hashCode());
        hashCode = 31 * hashCode + (this.getSourceCodeRepository() == null ? 0 : this.getSourceCodeRepository().hashCode());
        hashCode = 31 * hashCode + (this.getPublishedTime() == null ? 0 : this.getPublishedTime().hashCode());
        hashCode = 31 * hashCode + (this.getLicenses() == null ? 0 : this.getLicenses().hashCode());
        hashCode = 31 * hashCode + (this.getRevision() == null ? 0 : this.getRevision().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        return hashCode;
    }

    public PackageVersionDescription clone() {
        try {
            return (PackageVersionDescription)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PackageVersionDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

