/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.codegen.emitters;

import com.amazonaws.codegen.emitters.CodeWriter;
import com.amazonaws.codegen.emitters.GeneratorTask;
import com.amazonaws.codegen.internal.Utils;
import freemarker.template.Template;
import java.io.IOException;
import java.io.Writer;

public class FreemarkerGeneratorTask
implements GeneratorTask {
    private final Writer writer;
    private final Template template;
    private final Object dataModel;

    public FreemarkerGeneratorTask(String outputDirectory, String fileName, Template template, Object dataModel) throws IOException {
        if (dataModel == null) {
            throw new IllegalArgumentException("Data model cannot be null");
        }
        this.writer = new CodeWriter(outputDirectory, fileName);
        this.template = template;
        this.dataModel = dataModel;
    }

    public FreemarkerGeneratorTask(Writer writer, Template template, Object data) throws IOException {
        if (data == null) {
            throw new IllegalArgumentException("Data model cannot be null");
        }
        this.writer = writer;
        this.template = template;
        this.dataModel = data;
    }

    @Override
    public Void call() throws Exception {
        try {
            this.template.process(this.dataModel, this.writer);
        }
        finally {
            Utils.closeQuietly(this.writer);
        }
        return null;
    }
}

