/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.codegen.emitters.tasks;

import com.amazonaws.codegen.emitters.FreemarkerGeneratorTask;
import com.amazonaws.codegen.emitters.GeneratorTask;
import com.amazonaws.codegen.emitters.GeneratorTaskParams;
import com.amazonaws.codegen.emitters.tasks.BaseGeneratorTasks;
import com.amazonaws.codegen.model.intermediate.Metadata;
import com.amazonaws.codegen.model.intermediate.ShapeModel;
import com.amazonaws.codegen.model.intermediate.ShapeType;
import com.amazonaws.codegen.utils.FunctionalUtils;
import com.amazonaws.util.ImmutableMapParameter;
import freemarker.template.Template;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class MarshallerGeneratorTasks
extends BaseGeneratorTasks {
    private final String transformClassDir;
    private final Metadata metadata;
    private final Map<String, ShapeModel> shapes;

    public MarshallerGeneratorTasks(GeneratorTaskParams dependencies) {
        super(dependencies);
        this.transformClassDir = dependencies.getPathProvider().getTransformDirectory();
        this.metadata = this.model.getMetadata();
        this.shapes = this.model.getShapes();
    }

    @Override
    protected List<GeneratorTask> createTasks() throws Exception {
        this.info("Emitting marshaller classes");
        return this.model.getShapes().entrySet().stream().filter(e -> this.shouldGenerate((ShapeModel)e.getValue())).map(FunctionalUtils.safeFunction(e -> this.createTask((String)e.getKey(), (ShapeModel)e.getValue()))).collect(Collectors.toList());
    }

    private boolean shouldGenerate(ShapeModel shapeModel) {
        if (shapeModel.getCustomization().isSkipGeneratingMarshaller()) {
            System.out.println("Skip generating marshaller class for " + shapeModel.getShapeName());
            return false;
        }
        return this.shouldGenerate(shapeModel.getShapeType());
    }

    private boolean shouldGenerate(ShapeType shapeType) {
        return ShapeType.Request == shapeType || ShapeType.Model == shapeType && this.metadata.isJsonProtocol();
    }

    private GeneratorTask createTask(String javaShapeName, ShapeModel shapeModel) throws Exception {
        Template template = this.freemarker.getModelMarshallerTemplate();
        ShapeType shapeType = shapeModel.getShapeType();
        ImmutableMapParameter marshallerDataModel = ImmutableMapParameter.builder().put((Object)"fileHeader", (Object)this.model.getFileHeader()).put((Object)"shapeName", (Object)javaShapeName).put((Object)"shapes", this.shapes).put((Object)"metadata", (Object)this.metadata).put((Object)"transformPackage", (Object)this.model.getTransformPackage()).put((Object)"customConfig", (Object)this.model.getCustomizationConfig()).build();
        return new FreemarkerGeneratorTask(this.transformClassDir, this.getMarshallerClassName(shapeType, javaShapeName, this.metadata), template, marshallerDataModel);
    }

    private String getMarshallerClassName(ShapeType shapeType, String shapeName, Metadata metadata) {
        if (ShapeType.Request == shapeType) {
            return shapeName + "Marshaller";
        }
        if (ShapeType.Model == shapeType && metadata.isJsonProtocol()) {
            return shapeName + "JsonMarshaller";
        }
        throw new IllegalArgumentException("Not able generate marshaller class name for " + shapeName + " type " + shapeType.getValue());
    }
}

