/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.codegen.customization.processors;

import com.amazonaws.codegen.customization.CodegenCustomizationProcessor;
import com.amazonaws.codegen.internal.Utils;
import com.amazonaws.codegen.model.config.customization.CustomizationConfig;
import com.amazonaws.codegen.model.intermediate.IntermediateModel;
import com.amazonaws.codegen.model.intermediate.MemberModel;
import com.amazonaws.codegen.model.service.ServiceModel;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class EmitLegacyEnumSetterProcessor
implements CodegenCustomizationProcessor {
    private final Map<String, List<String>> emitLegacyEnumSetterFor;
    private final boolean shouldEmitEnumSetterOverload;

    public EmitLegacyEnumSetterProcessor(CustomizationConfig customizationConfig) {
        this.emitLegacyEnumSetterFor = customizationConfig.getEmitLegacyEnumSetterFor() != null ? customizationConfig.getEmitLegacyEnumSetterFor() : Collections.emptyMap();
        this.shouldEmitEnumSetterOverload = customizationConfig.emitEnumSetterOverload();
    }

    @Override
    public void preprocess(ServiceModel serviceModel) {
    }

    @Override
    public void postprocess(IntermediateModel intermediateModel) {
        EmitLegacyEnumSetterProcessor.assertShapeAndMembersAreInModel(intermediateModel, this.emitLegacyEnumSetterFor);
        intermediateModel.getShapes().values().stream().filter(s -> s.getMembers() != null).forEach(s -> s.getMembers().forEach(member -> this.applyCustomization(s.getC2jName(), (MemberModel)member)));
    }

    private void applyCustomization(String parentShapeName, MemberModel member) {
        if (this.emitLegacyEnumSetterFor.containsKey(parentShapeName)) {
            this.emitLegacyEnumSetterFor.get(parentShapeName).forEach(memberName -> member.setShouldEmitLegacyEnumSetter(true));
        } else {
            member.setShouldEmitLegacyEnumSetter(this.shouldEmitEnumSetterOverload);
        }
    }

    private static void assertShapeAndMembersAreInModel(IntermediateModel model, Map<String, List<String>> shapeAndMembers) {
        shapeAndMembers.forEach((shapeName, members) -> {
            if (Utils.findShapeModelByC2jNameIfExists(model, shapeName) == null) {
                throw new IllegalStateException(String.format("Cannot find shape [%s] in the model when processing customization config emitLegacyEnumSetterFor. %s", shapeName, shapeName));
            }
            members.forEach(memberName -> {
                if (model.getShapeByC2jName((String)shapeName).getMemberByC2jName((String)memberName) == null) {
                    throw new IllegalStateException(String.format("Cannot find member [%s] in the model when processing customization config emitLegacyEnumSetterFor. %s", memberName, shapeName));
                }
            });
        });
    }
}

