/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.codegen.internal;

import com.amazonaws.codegen.internal.Constants;
import com.amazonaws.codegen.model.intermediate.IntermediateModel;
import com.amazonaws.codegen.model.intermediate.Metadata;
import com.amazonaws.codegen.model.intermediate.ShapeMarshaller;
import com.amazonaws.codegen.model.intermediate.ShapeModel;
import com.amazonaws.codegen.model.service.Input;
import com.amazonaws.codegen.model.service.Operation;
import com.amazonaws.codegen.model.service.ServiceMetadata;
import com.amazonaws.codegen.model.service.ServiceModel;
import com.amazonaws.codegen.model.service.Shape;
import com.amazonaws.codegen.model.service.XmlNamespace;
import com.amazonaws.util.StringUtils;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class Utils {
    public static boolean isScalar(Shape shape) {
        return !Utils.isListShape(shape) && !Utils.isStructure(shape) && !Utils.isMapShape(shape);
    }

    public static boolean isStructure(Shape shape) {
        return shape.getType().equals("structure");
    }

    public static boolean isListShape(Shape shape) {
        return shape.getType().equals("list");
    }

    public static boolean isMapShape(Shape shape) {
        return shape.getType().equals("map");
    }

    public static boolean isEnumShape(Shape shape) {
        return shape.getEnumValues() != null;
    }

    public static boolean isExceptionShape(Shape shape) {
        return shape.isException() || shape.isFault();
    }

    public static String getAsyncInterfaceName(String interfaceNamePrefix) {
        return interfaceNamePrefix + "Async";
    }

    public static String getClientName(String clientNamePrefix) {
        return clientNamePrefix + "Client";
    }

    public static String unCapitialize(String name) {
        if (name == null || name.trim().isEmpty()) {
            throw new IllegalArgumentException("Name cannot be null or empty");
        }
        return name.length() < 2 ? StringUtils.lowerCase((String)name) : StringUtils.lowerCase((String)name.substring(0, 1)) + name.substring(1);
    }

    public static String capitialize(String name) {
        if (name == null || name.trim().isEmpty()) {
            throw new IllegalArgumentException("Name cannot be null or empty");
        }
        return name.length() < 2 ? StringUtils.upperCase((String)name) : StringUtils.upperCase((String)name.substring(0, 1)) + name.substring(1);
    }

    public static String getFileNamePrefix(ServiceModel serviceModel) {
        return String.format("%s-%s", serviceModel.getMetadata().getEndpointPrefix(), serviceModel.getMetadata().getApiVersion());
    }

    public static String directoryToPackage(String directoryPath) {
        return directoryPath.replace('/', '.');
    }

    public static String getDefaultEndpointWithoutHttpProtocol(String endpoint) {
        if (endpoint == null) {
            return null;
        }
        if (endpoint.startsWith("http://")) {
            return endpoint.substring("http://".length());
        }
        if (endpoint.startsWith("https://")) {
            return endpoint.substring("https://".length());
        }
        return endpoint;
    }

    public static File createDirectory(String path) {
        if (Utils.isNullOrEmpty(path)) {
            throw new IllegalArgumentException("Invalid path directory. Path directory cannot be null or empty");
        }
        File dir = new File(path);
        Utils.createDirectory(dir);
        return dir;
    }

    public static void createDirectory(File dir) {
        if (!dir.exists() && !dir.mkdirs()) {
            throw new RuntimeException("Not able to create directory. " + dir.getAbsolutePath());
        }
    }

    public static File createFile(String dir, String fileName) throws IOException {
        if (Utils.isNullOrEmpty(fileName)) {
            throw new IllegalArgumentException("Invalid file name. File name cannot be null or empty");
        }
        Utils.createDirectory(dir);
        File file = new File(dir, fileName);
        if (!file.exists() && !file.createNewFile()) {
            throw new RuntimeException("Not able to create file . " + file.getAbsolutePath());
        }
        return file;
    }

    public static boolean isNullOrEmpty(String str) {
        return str == null || str.trim().isEmpty();
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (Exception e) {
            Constants.LOGGER.debug((Object)"Not able to close the stream.");
        }
    }

    public static InputStream getRequiredResourceAsStream(Class<?> clzz, String location) {
        InputStream resourceStream = clzz.getResourceAsStream(location);
        if (resourceStream == null) {
            if (!location.startsWith("/")) {
                resourceStream = clzz.getResourceAsStream("/" + location);
            }
            if (resourceStream == null) {
                throw new RuntimeException("Resource file was not found at location " + location);
            }
        }
        return resourceStream;
    }

    public static String getRequiredSystemProperty(String propertyName, String errorMsgIfNotFound) {
        String propertyValue = System.getProperty(propertyName);
        if (propertyValue == null) {
            throw new RuntimeException(errorMsgIfNotFound);
        }
        return propertyValue;
    }

    public static String getOptionalSystemProperty(String propertyName) {
        return System.getProperty(propertyName);
    }

    public static <T> T assertNotNull(T argument, String msg) {
        if (argument == null) {
            throw new IllegalArgumentException(msg);
        }
        return argument;
    }

    public static ShapeModel findShapeModelByC2jName(IntermediateModel intermediateModel, String shapeC2jName) throws IllegalArgumentException {
        ShapeModel shapeModel = Utils.findShapeModelByC2jNameIfExists(intermediateModel, shapeC2jName);
        if (shapeModel != null) {
            return shapeModel;
        }
        throw new IllegalArgumentException(shapeC2jName + " shape (c2j name) does not exist in the intermediate model.");
    }

    public static ShapeModel findShapeModelByC2jNameIfExists(IntermediateModel intermediateModel, String shapeC2jName) {
        for (ShapeModel shape : intermediateModel.getShapes().values()) {
            if (!shape.getC2jName().equals(shapeC2jName)) continue;
            return shape;
        }
        return null;
    }

    public static ShapeMarshaller createInputShapeMarshaller(ServiceMetadata service, Operation operation) {
        if (operation == null) {
            throw new IllegalArgumentException("The operation parameter must be specified!");
        }
        ShapeMarshaller marshaller = new ShapeMarshaller().withAction(operation.getName()).withVerb(operation.getHttp().getMethod()).withRequestUri(operation.getHttp().getRequestUri());
        Input input = operation.getInput();
        if (input != null) {
            marshaller.setLocationName(input.getLocationName());
            XmlNamespace xmlNamespace = input.getXmlNamespace();
            if (xmlNamespace != null) {
                marshaller.setXmlNameSpaceUri(xmlNamespace.getUri());
            }
        }
        if (!StringUtils.isNullOrEmpty((String)service.getTargetPrefix()) && Metadata.isNotRestProtocol(service.getProtocol())) {
            marshaller.setTarget(service.getTargetPrefix() + "." + operation.getName());
        }
        return marshaller;
    }
}

